/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.ai.token.limiter.handler;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.shenyu.common.dto.PluginData;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.dto.convert.rule.AiTokenLimiterHandle;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.infra.redis.RedisConfigProperties;
import org.apache.shenyu.infra.redis.RedisConnectionFactory;
import org.apache.shenyu.infra.redis.ShenyuReactiveRedisTemplate;
import org.apache.shenyu.infra.redis.serializer.ShenyuRedisSerializationContext;
import org.apache.shenyu.plugin.base.cache.CommonHandleCache;
import org.apache.shenyu.plugin.base.handler.PluginDataHandler;
import org.apache.shenyu.plugin.base.utils.BeanHolder;
import org.apache.shenyu.plugin.base.utils.CacheKeyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.connection.ReactiveRedisConnectionFactory;
import org.springframework.data.redis.core.ReactiveRedisTemplate;

public class AiTokenLimiterPluginHandler
implements PluginDataHandler {
    public static final Supplier<CommonHandleCache<String, ReactiveRedisTemplate>> REDIS_CACHED_HANDLE = new BeanHolder(CommonHandleCache::new);
    public static final Supplier<CommonHandleCache<String, RedisConfigProperties>> REDIS_PROPERTIES_CACHED_HANDLE = new BeanHolder(CommonHandleCache::new);
    public static final Supplier<CommonHandleCache<String, AiTokenLimiterHandle>> CACHED_HANDLE = new BeanHolder(CommonHandleCache::new);
    private static final Logger LOG = LoggerFactory.getLogger(AiTokenLimiterPluginHandler.class);

    public void handlerPlugin(PluginData pluginData) {
        if (Objects.nonNull(pluginData) && Boolean.TRUE.equals(pluginData.getEnabled())) {
            RedisConfigProperties redisConfigProperties = (RedisConfigProperties)GsonUtils.getInstance().fromJson(pluginData.getConfig(), RedisConfigProperties.class);
            if (Objects.isNull(REDIS_CACHED_HANDLE.get().obtainHandle((Object)PluginEnum.AI_TOKEN_LIMITER.getName())) || Objects.isNull(REDIS_PROPERTIES_CACHED_HANDLE.get().obtainHandle((Object)PluginEnum.AI_TOKEN_LIMITER.getName())) || !redisConfigProperties.equals(REDIS_PROPERTIES_CACHED_HANDLE.get().obtainHandle((Object)PluginEnum.AI_TOKEN_LIMITER.getName()))) {
                RedisConnectionFactory redisConnectionFactory = new RedisConnectionFactory(redisConfigProperties);
                ShenyuReactiveRedisTemplate reactiveRedisTemplate = new ShenyuReactiveRedisTemplate((ReactiveRedisConnectionFactory)redisConnectionFactory.getLettuceConnectionFactory(), ShenyuRedisSerializationContext.stringSerializationContext());
                REDIS_CACHED_HANDLE.get().cachedHandle((Object)PluginEnum.AI_TOKEN_LIMITER.getName(), (Object)reactiveRedisTemplate);
                REDIS_PROPERTIES_CACHED_HANDLE.get().cachedHandle((Object)PluginEnum.AI_TOKEN_LIMITER.getName(), (Object)redisConfigProperties);
            }
        }
    }

    public void handlerSelector(SelectorData selectorData) {
        if (!selectorData.getContinued().booleanValue()) {
            CACHED_HANDLE.get().cachedHandle((Object)CacheKeyUtils.INST.getKey(selectorData.getId(), "default_rule"), (Object)AiTokenLimiterHandle.newDefaultInstance());
        }
    }

    public void removeSelector(SelectorData selectorData) {
        CACHED_HANDLE.get().removeHandle((Object)CacheKeyUtils.INST.getKey(selectorData.getId(), "default_rule"));
    }

    public void handlerRule(RuleData ruleData) {
        Optional.ofNullable(ruleData.getHandle()).ifPresent(s -> {
            AiTokenLimiterHandle rateLimiterHandle = (AiTokenLimiterHandle)GsonUtils.getInstance().fromJson(s, AiTokenLimiterHandle.class);
            CACHED_HANDLE.get().cachedHandle((Object)CacheKeyUtils.INST.getKey(ruleData), (Object)rateLimiterHandle);
        });
    }

    public void removeRule(RuleData ruleData) {
        Optional.ofNullable(ruleData.getHandle()).ifPresent(s -> CACHED_HANDLE.get().removeHandle((Object)CacheKeyUtils.INST.getKey(ruleData)));
    }

    public String pluginNamed() {
        return PluginEnum.AI_TOKEN_LIMITER.getName();
    }
}

