/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.GeoBounds;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.aggregations.AggregationVariant;
import co.elastic.clients.elasticsearch._types.aggregations.BucketAggregationBase;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class GeohexGridAggregation
extends BucketAggregationBase
implements AggregationVariant {
    private final String field;
    @Nullable
    private final Integer precision;
    @Nullable
    private final GeoBounds bounds;
    @Nullable
    private final Integer size;
    @Nullable
    private final Integer shardSize;
    public static final JsonpDeserializer<GeohexGridAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GeohexGridAggregation::setupGeohexGridAggregationDeserializer);

    private GeohexGridAggregation(Builder builder) {
        super(builder);
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.precision = builder.precision;
        this.bounds = builder.bounds;
        this.size = builder.size;
        this.shardSize = builder.shardSize;
    }

    public static GeohexGridAggregation of(Function<Builder, ObjectBuilder<GeohexGridAggregation>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregation.Kind _aggregationKind() {
        return Aggregation.Kind.GeohexGrid;
    }

    public final String field() {
        return this.field;
    }

    @Nullable
    public final Integer precision() {
        return this.precision;
    }

    @Nullable
    public final GeoBounds bounds() {
        return this.bounds;
    }

    @Nullable
    public final Integer size() {
        return this.size;
    }

    @Nullable
    public final Integer shardSize() {
        return this.shardSize;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("field");
        generator.write(this.field);
        if (this.precision != null) {
            generator.writeKey("precision");
            generator.write(this.precision.intValue());
        }
        if (this.bounds != null) {
            generator.writeKey("bounds");
            this.bounds.serialize(generator, mapper);
        }
        if (this.size != null) {
            generator.writeKey("size");
            generator.write(this.size.intValue());
        }
        if (this.shardSize != null) {
            generator.writeKey("shard_size");
            generator.write(this.shardSize.intValue());
        }
    }

    protected static void setupGeohexGridAggregationDeserializer(ObjectDeserializer<Builder> op) {
        BucketAggregationBase.setupBucketAggregationBaseDeserializer(op);
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::precision, JsonpDeserializer.integerDeserializer(), "precision");
        op.add(Builder::bounds, GeoBounds._DESERIALIZER, "bounds");
        op.add(Builder::size, JsonpDeserializer.integerDeserializer(), "size");
        op.add(Builder::shardSize, JsonpDeserializer.integerDeserializer(), "shard_size");
    }

    public static class Builder
    extends BucketAggregationBase.AbstractBuilder<Builder>
    implements ObjectBuilder<GeohexGridAggregation> {
        private String field;
        @Nullable
        private Integer precision;
        @Nullable
        private GeoBounds bounds;
        @Nullable
        private Integer size;
        @Nullable
        private Integer shardSize;

        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        public final Builder precision(@Nullable Integer value) {
            this.precision = value;
            return this;
        }

        public final Builder bounds(@Nullable GeoBounds value) {
            this.bounds = value;
            return this;
        }

        public final Builder bounds(Function<GeoBounds.Builder, ObjectBuilder<GeoBounds>> fn) {
            return this.bounds(fn.apply(new GeoBounds.Builder()).build());
        }

        public final Builder size(@Nullable Integer value) {
            this.size = value;
            return this;
        }

        public final Builder shardSize(@Nullable Integer value) {
            this.shardSize = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GeohexGridAggregation build() {
            this._checkSingleUse();
            return new GeohexGridAggregation(this);
        }
    }
}

