/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api.recursive.comparison;

import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.assertj.core.api.recursive.comparison.RecursiveComparisonIntrospectionStrategy;
import org.assertj.core.internal.Objects;
import org.assertj.core.util.introspection.IntrospectionError;
import org.assertj.core.util.introspection.PropertyOrFieldSupport;

public abstract class ComparingNormalizedFields
implements RecursiveComparisonIntrospectionStrategy {
    private static final String NO_FIELD_FOUND = "Unable to find field in %s, fields tried: %s and %s";
    private final Map<Object, Map<String, String>> originalFieldNamesByNormalizedFieldNameByNode = new IdentityHashMap<Object, Map<String, String>>();
    private final Map<Class<?>, Set<String>> fieldNamesPerClass = new ConcurrentHashMap();

    @Override
    public Set<String> getChildrenNodeNamesOf(Object node) {
        if (node == null) {
            return new HashSet<String>();
        }
        Set<String> fieldsNames = Objects.getFieldsNames(node.getClass());
        return this.fieldNamesPerClass.computeIfAbsent(node.getClass(), unused -> fieldsNames.stream().map(fieldsName -> this.normalize(node, (String)fieldsName)).collect(Collectors.toSet()));
    }

    protected abstract String normalizeFieldName(String var1);

    private String normalize(Object node, String fieldName) {
        String normalizedFieldName = this.normalizeFieldName(fieldName);
        if (!this.originalFieldNamesByNormalizedFieldNameByNode.containsKey(node)) {
            this.originalFieldNamesByNormalizedFieldNameByNode.put(node, new HashMap());
        }
        this.originalFieldNamesByNormalizedFieldNameByNode.get(node).put(normalizedFieldName, fieldName);
        return normalizedFieldName;
    }

    @Override
    public Object getChildNodeValue(String fieldName, Object instance) {
        try {
            return PropertyOrFieldSupport.COMPARISON.getSimpleValue(fieldName, instance);
        }
        catch (Exception e) {
            String originalFieldName = this.getOriginalFieldName(fieldName, instance);
            try {
                return PropertyOrFieldSupport.COMPARISON.getSimpleValue(originalFieldName, instance);
            }
            catch (Exception ex) {
                throw new IntrospectionError(String.format(NO_FIELD_FOUND, instance, fieldName, originalFieldName), ex);
            }
        }
    }

    private String getOriginalFieldName(String fieldName, Object instance) {
        if (!this.originalFieldNamesByNormalizedFieldNameByNode.containsKey(instance)) {
            this.getChildrenNodeNamesOf(instance);
        }
        return this.originalFieldNamesByNormalizedFieldNameByNode.get(instance).get(fieldName);
    }

    @Override
    public String getDescription() {
        return "comparing normalized fields";
    }
}

