/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.common.tracer.core.appender.manager;

import com.alipay.common.tracer.core.appender.TraceAppender;
import com.alipay.common.tracer.core.appender.encoder.SpanEncoder;
import com.alipay.common.tracer.core.appender.file.LoadTestAwareAppender;
import com.alipay.common.tracer.core.appender.manager.ConsumerExceptionHandler;
import com.alipay.common.tracer.core.appender.manager.ConsumerThreadFactory;
import com.alipay.common.tracer.core.appender.manager.SofaTracerSpanEvent;
import com.alipay.common.tracer.core.appender.manager.SofaTracerSpanEventFactory;
import com.alipay.common.tracer.core.appender.self.SynchronizingSelfLog;
import com.alipay.common.tracer.core.configuration.SofaTracerConfiguration;
import com.alipay.common.tracer.core.context.span.SofaTracerSpanContext;
import com.alipay.common.tracer.core.span.SofaTracerSpan;
import com.alipay.common.tracer.core.utils.TracerUtils;
import com.alipay.disruptor.BlockingWaitStrategy;
import com.alipay.disruptor.EventHandler;
import com.alipay.disruptor.InsufficientCapacityException;
import com.alipay.disruptor.RingBuffer;
import com.alipay.disruptor.WaitStrategy;
import com.alipay.disruptor.dsl.Disruptor;
import com.alipay.disruptor.dsl.ProducerType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class AsyncCommonDigestAppenderManager {
    private final Map<String, TraceAppender> appenders = new ConcurrentHashMap<String, TraceAppender>();
    private final Map<String, SpanEncoder> contextEncoders = new ConcurrentHashMap<String, SpanEncoder>();
    private Disruptor<SofaTracerSpanEvent> disruptor;
    private RingBuffer<SofaTracerSpanEvent> ringBuffer;
    private final ConsumerThreadFactory threadFactory = new ConsumerThreadFactory();
    private List<Consumer> consumers;
    private AtomicInteger index = new AtomicInteger(0);
    private static final int DEFAULT_CONSUMER_NUMBER = 3;
    private boolean allowDiscard;
    private boolean isOutDiscardNumber;
    private boolean isOutDiscardId;
    private long discardOutThreshold;
    private PaddedAtomicLong discardCount;
    private static final String DEFAULT_ALLOW_DISCARD = "true";
    private static final String DEFAULT_IS_OUT_DISCARD_NUMBER = "true";
    private static final String DEFAULT_IS_OUT_DISCARD_ID = "false";
    private static final String DEFAULT_DISCARD_OUT_THRESHOLD = "500";

    public AsyncCommonDigestAppenderManager(int queueSize, int consumerNumber) {
        int realQueueSize = 1 << 32 - Integer.numberOfLeadingZeros(queueSize - 1);
        this.disruptor = new Disruptor<SofaTracerSpanEvent>(new SofaTracerSpanEventFactory(), realQueueSize, this.threadFactory, ProducerType.MULTI, (WaitStrategy)new BlockingWaitStrategy());
        this.consumers = new ArrayList<Consumer>(consumerNumber);
        for (int i = 0; i < consumerNumber; ++i) {
            Consumer consumer = new Consumer();
            this.consumers.add(consumer);
            this.disruptor.setDefaultExceptionHandler(new ConsumerExceptionHandler());
            this.disruptor.handleEventsWith(consumer);
        }
        this.allowDiscard = Boolean.parseBoolean(SofaTracerConfiguration.getProperty("tracer_async_appender_allow_discard", "true"));
        if (this.allowDiscard) {
            this.isOutDiscardNumber = Boolean.parseBoolean(SofaTracerConfiguration.getProperty("tracer_async_appender_is_out_discard_number", "true"));
            this.isOutDiscardId = Boolean.parseBoolean(SofaTracerConfiguration.getProperty("tracer_async_appender_is_out_discard_id", DEFAULT_IS_OUT_DISCARD_ID));
            this.discardOutThreshold = Long.parseLong(SofaTracerConfiguration.getProperty("tracer_async_appender_discard_out_threshold", DEFAULT_DISCARD_OUT_THRESHOLD));
            if (this.isOutDiscardNumber) {
                this.discardCount = new PaddedAtomicLong(0L);
            }
        }
    }

    public AsyncCommonDigestAppenderManager(int queueSize) {
        this(queueSize, 3);
    }

    public void start(String workerName) {
        this.threadFactory.setWorkName(workerName);
        this.ringBuffer = this.disruptor.start();
    }

    public void addAppender(String logType, TraceAppender appender, SpanEncoder encoder) {
        if (this.isAppenderOrEncoderExist(logType)) {
            SynchronizingSelfLog.error("logType[" + logType + "] already is added AsyncCommonDigestAppenderManager");
            return;
        }
        this.appenders.put(logType, appender);
        this.contextEncoders.put(logType, encoder);
        this.consumers.get(this.index.incrementAndGet() % this.consumers.size()).addLogType(logType);
    }

    public boolean isAppenderOrEncoderExist(String logType) {
        return this.appenders.containsKey(logType) || this.contextEncoders.containsKey(logType);
    }

    public boolean isAppenderAndEncoderExist(String logType) {
        return this.appenders.containsKey(logType) && this.contextEncoders.containsKey(logType);
    }

    public boolean isAppenderExist(Character logType) {
        return this.appenders.containsKey(logType);
    }

    public boolean append(SofaTracerSpan sofaTracerSpan) {
        long sequence = 0L;
        if (this.allowDiscard) {
            try {
                sequence = this.ringBuffer.tryNext();
            }
            catch (InsufficientCapacityException e) {
                SofaTracerSpanContext sofaTracerSpanContext;
                if (this.isOutDiscardId && (sofaTracerSpanContext = sofaTracerSpan.getSofaTracerSpanContext()) != null) {
                    SynchronizingSelfLog.warn("discarded tracer: traceId[" + sofaTracerSpanContext.getTraceId() + "];spanId[" + sofaTracerSpanContext.getSpanId() + "]");
                }
                if (this.isOutDiscardNumber && this.discardCount.incrementAndGet() == this.discardOutThreshold) {
                    this.discardCount.set(0L);
                    if (this.isOutDiscardNumber) {
                        SynchronizingSelfLog.warn("discarded " + this.discardOutThreshold + " logs");
                    }
                }
                return false;
            }
        } else {
            sequence = this.ringBuffer.next();
        }
        try {
            SofaTracerSpanEvent event = this.ringBuffer.get(sequence);
            event.setSofaTracerSpan(sofaTracerSpan);
        }
        catch (Exception e) {
            SynchronizingSelfLog.error("fail to add event");
            return false;
        }
        this.ringBuffer.publish(sequence);
        return true;
    }

    class PaddedAtomicLong
    extends AtomicLong {
        public volatile long p1;
        public volatile long p2;
        public volatile long p3;
        public volatile long p4;
        public volatile long p5;
        public volatile long p6;

        public PaddedAtomicLong(long initialValue) {
            super(initialValue);
            this.p6 = 7L;
        }

        public PaddedAtomicLong() {
            this.p6 = 7L;
        }
    }

    private class Consumer
    implements EventHandler<SofaTracerSpanEvent> {
        protected Set<String> logTypes = Collections.synchronizedSet(new HashSet());

        private Consumer() {
        }

        @Override
        public void onEvent(SofaTracerSpanEvent event, long sequence, boolean endOfBatch) throws Exception {
            SofaTracerSpan sofaTracerSpan = event.getSofaTracerSpan();
            if (sofaTracerSpan != null) {
                try {
                    String logType = sofaTracerSpan.getLogType();
                    if (this.logTypes.contains(logType)) {
                        SpanEncoder encoder = (SpanEncoder)AsyncCommonDigestAppenderManager.this.contextEncoders.get(logType);
                        TraceAppender appender = (TraceAppender)AsyncCommonDigestAppenderManager.this.appenders.get(logType);
                        String encodedStr = encoder.encode(sofaTracerSpan);
                        if (appender instanceof LoadTestAwareAppender) {
                            ((LoadTestAwareAppender)appender).append(encodedStr, TracerUtils.isLoadTest(sofaTracerSpan));
                        } else {
                            appender.append(encodedStr);
                        }
                        appender.flush();
                    }
                }
                catch (Exception e) {
                    SofaTracerSpanContext sofaTracerSpanContext = sofaTracerSpan.getSofaTracerSpanContext();
                    if (sofaTracerSpanContext != null) {
                        SynchronizingSelfLog.error("fail to async write log,tracerId[" + sofaTracerSpanContext.getTraceId() + "];spanId[" + sofaTracerSpanContext.getSpanId() + "]", e);
                    }
                    SynchronizingSelfLog.error("fail to async write log.And the sofaTracerSpanContext is null", e);
                }
            }
        }

        public void addLogType(String logType) {
            this.logTypes.add(logType);
        }
    }
}

