/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.server.http;

import com.alipay.sofa.rpc.codec.Serializer;
import com.alipay.sofa.rpc.codec.SerializerFactory;
import com.alipay.sofa.rpc.codec.common.StringSerializer;
import com.alipay.sofa.rpc.common.cache.ReflectCache;
import com.alipay.sofa.rpc.common.utils.CodecUtils;
import com.alipay.sofa.rpc.common.utils.ExceptionUtils;
import com.alipay.sofa.rpc.config.ProviderConfig;
import com.alipay.sofa.rpc.context.RpcInternalContext;
import com.alipay.sofa.rpc.context.RpcInvokeContext;
import com.alipay.sofa.rpc.context.RpcRuntimeContext;
import com.alipay.sofa.rpc.core.exception.SofaRpcException;
import com.alipay.sofa.rpc.core.request.SofaRequest;
import com.alipay.sofa.rpc.core.response.SofaResponse;
import com.alipay.sofa.rpc.event.EventBus;
import com.alipay.sofa.rpc.event.ServerEndHandleEvent;
import com.alipay.sofa.rpc.event.ServerReceiveEvent;
import com.alipay.sofa.rpc.event.ServerSendEvent;
import com.alipay.sofa.rpc.invoke.Invoker;
import com.alipay.sofa.rpc.log.LogCodes;
import com.alipay.sofa.rpc.log.Logger;
import com.alipay.sofa.rpc.log.LoggerFactory;
import com.alipay.sofa.rpc.message.MessageBuilder;
import com.alipay.sofa.rpc.server.AbstractTask;
import com.alipay.sofa.rpc.server.ProviderProxyInvoker;
import com.alipay.sofa.rpc.server.http.Http2ServerTask;
import com.alipay.sofa.rpc.server.http.HttpServerHandler;
import com.alipay.sofa.rpc.transport.AbstractByteBuf;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.util.HashMap;

public abstract class AbstractHttpServerTask
extends AbstractTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(Http2ServerTask.class);
    protected final SofaRequest request;
    protected final ChannelHandlerContext ctx;
    protected final HttpServerHandler serverHandler;

    public AbstractHttpServerTask(HttpServerHandler serverHandler, SofaRequest request, ChannelHandlerContext ctx) {
        this.serverHandler = serverHandler;
        this.request = request;
        this.ctx = ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block31: {
            RpcInternalContext context = RpcInternalContext.getContext();
            context.setProviderSide(true);
            String appName = this.request.getTargetAppName();
            if (appName == null) {
                appName = (String)RpcRuntimeContext.get("appName");
            }
            try {
                Serializer serializer;
                HttpResponseStatus status;
                Exception throwable;
                SofaResponse response;
                block29: {
                    Channel channel = this.ctx.channel();
                    context.setRemoteAddress((InetSocketAddress)channel.remoteAddress());
                    context.setAttachment(".async_context", channel);
                    if (EventBus.isEnable(ServerReceiveEvent.class)) {
                        EventBus.post(new ServerReceiveEvent(this.request));
                    }
                    response = null;
                    throwable = null;
                    status = null;
                    ProviderConfig providerConfig = null;
                    String serviceName = this.request.getTargetServiceUniqueName();
                    serializer = null;
                    if (this.request.getSerializeType() > 0) {
                        serializer = SerializerFactory.getSerializer(this.request.getSerializeType());
                    }
                    try {
                        Invoker invoker;
                        block30: {
                            String methodName;
                            Method serviceMethod;
                            invoker = this.serverHandler.getInvokerMap().get(serviceName);
                            if (invoker == null) {
                                throwable = this.cannotFoundService(appName, serviceName);
                                response = MessageBuilder.buildSofaErrorResponse(throwable.getMessage());
                                status = HttpResponseStatus.NOT_FOUND;
                                break block29;
                            }
                            if (invoker instanceof ProviderProxyInvoker) {
                                providerConfig = ((ProviderProxyInvoker)invoker).getProviderConfig();
                                String string = appName = providerConfig != null ? providerConfig.getAppName() : null;
                            }
                            if ((serviceMethod = this.serverHandler.getMethod(serviceName, methodName = this.request.getMethodName())) == null) {
                                throwable = this.cannotFoundServiceMethod(appName, methodName, serviceName);
                                response = MessageBuilder.buildSofaErrorResponse(throwable.getMessage());
                                status = HttpResponseStatus.NOT_FOUND;
                                break block29;
                            }
                            this.request.setMethod(serviceMethod);
                            AbstractByteBuf reqData = this.request.getData();
                            if (reqData != null) {
                                try {
                                    HashMap<String, String> map = new HashMap<String, String>(4);
                                    map.put("sofa_head_target_service", this.request.getTargetServiceUniqueName());
                                    map.put("sofa_head_method_name", this.request.getMethodName());
                                    map.put("sofa_head_target_app", this.request.getTargetAppName());
                                    serializer.decode(reqData, this.request, map);
                                    break block30;
                                }
                                catch (Exception e) {
                                    LOGGER.errorWithApp(appName, "Server deserialize error, request from " + channel.remoteAddress(), e);
                                    response = MessageBuilder.buildSofaErrorResponse("Server deserialize error, " + e.getMessage());
                                    break block29;
                                }
                            }
                            if (this.request.getMethodArgs() == null) {
                                this.request.setMethodArgs(CodecUtils.EMPTY_OBJECT_ARRAY);
                            }
                        }
                        response = this.doInvoke(serviceName, invoker, this.request);
                    }
                    catch (Exception e) {
                        LOGGER.errorWithApp(appName, "Server Processor Error!", e);
                        throwable = e;
                        response = MessageBuilder.buildSofaErrorResponse(e.getMessage());
                        status = HttpResponseStatus.INTERNAL_SERVER_ERROR;
                    }
                }
                if (response == null) break block31;
                response.setSerializeType(this.request.getSerializeType());
                try {
                    ByteBuf content;
                    if (response.isError()) {
                        content = this.ctx.alloc().buffer();
                        content.writeBytes(StringSerializer.encode(response.getErrorMsg()));
                        this.sendRpcError(status == null ? HttpResponseStatus.INTERNAL_SERVER_ERROR : status, content);
                    } else if (response.getAppResponse() instanceof Throwable) {
                        content = this.ctx.alloc().buffer();
                        String errorMsg = ExceptionUtils.toString((Throwable)response.getAppResponse());
                        content.writeBytes(StringSerializer.encode(errorMsg));
                        this.sendAppError(HttpResponseStatus.OK, content);
                    } else {
                        content = this.ctx.alloc().buffer();
                        if (this.request.getSerializeType() > 0) {
                            AbstractByteBuf bs = serializer.encode(response, null);
                            content.writeBytes(bs.array());
                        } else {
                            content.writeBytes(StringSerializer.encode(response.getAppResponse().toString()));
                        }
                        this.sendAppResponse(HttpResponseStatus.OK, content);
                    }
                }
                finally {
                    if (EventBus.isEnable(ServerSendEvent.class)) {
                        EventBus.post(new ServerSendEvent(this.request, response, throwable));
                    }
                }
            }
            catch (Throwable e) {
                if (LOGGER.isErrorEnabled(appName)) {
                    LOGGER.errorWithApp(appName, e.getMessage(), e);
                }
            }
            finally {
                this.serverHandler.getProcessingCount().decrementAndGet();
                if (EventBus.isEnable(ServerEndHandleEvent.class)) {
                    EventBus.post(new ServerEndHandleEvent());
                }
                RpcInvokeContext.removeContext();
                RpcInternalContext.removeAllContext();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SofaResponse doInvoke(String serviceName, Invoker invoker, SofaRequest request) throws SofaRpcException {
        ClassLoader rpcCl = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader serviceCl = ReflectCache.getServiceClassLoader(serviceName);
            Thread.currentThread().setContextClassLoader(serviceCl);
            SofaResponse sofaResponse = invoker.invoke(request);
            return sofaResponse;
        }
        finally {
            Thread.currentThread().setContextClassLoader(rpcCl);
        }
    }

    protected abstract void sendAppResponse(HttpResponseStatus var1, ByteBuf var2);

    protected abstract void sendAppError(HttpResponseStatus var1, ByteBuf var2);

    protected abstract void sendRpcError(HttpResponseStatus var1, ByteBuf var2);

    private SofaRpcException cannotFoundService(String appName, String serviceName) {
        String errorMsg = LogCodes.getLog("020100010", serviceName);
        LOGGER.errorWithApp(appName, errorMsg);
        return new SofaRpcException(110, errorMsg);
    }

    private SofaRpcException cannotFoundServiceMethod(String appName, String serviceName, String methodName) {
        String errorMsg = LogCodes.getLog("020100011", methodName, serviceName);
        LOGGER.errorWithApp(appName, errorMsg);
        return new SofaRpcException(110, errorMsg);
    }
}

