/*
 * Decompiled with CFR 0.152.
 */
package org.casbin.casdoor.service;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.casbin.casdoor.config.CasdoorConfig;
import org.casbin.casdoor.entity.CasdoorEmailForm;
import org.casbin.casdoor.util.http.CasdoorResponse;
import org.casbin.casdoor.util.http.HttpClient;

public class CasdoorEmailService {
    private final CasdoorConfig casdoorConfig;
    private final ObjectMapper objectMapper = new ObjectMapper();

    public CasdoorEmailService(CasdoorConfig casdoorConfig) {
        this.casdoorConfig = casdoorConfig;
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public CasdoorResponse sendEmail(String title, String content, String sender, String ... receivers) throws IOException {
        String targetUrl = String.format("%s/api/send-email?clientId=%s&clientSecret=%s", this.casdoorConfig.getEndpoint(), this.casdoorConfig.getClientId(), this.casdoorConfig.getClientSecret());
        CasdoorEmailForm casdoorEmailForm = new CasdoorEmailForm(title, content, sender, receivers);
        String emailFormStr = this.objectMapper.writeValueAsString((Object)casdoorEmailForm);
        String responseStr = HttpClient.postString(targetUrl, emailFormStr);
        return (CasdoorResponse)this.objectMapper.readValue(responseStr, CasdoorResponse.class);
    }
}

