/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.cryptor.strategy;

import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import javax.crypto.Cipher;
import org.apache.shenyu.plugin.cryptor.strategy.CryptorStrategy;
import org.apache.shenyu.spi.Join;

@Join
public class RsaStrategy
implements CryptorStrategy {
    private static final String RSA = "rsa";

    @Override
    public String decrypt(String key, byte[] encryptData) throws Exception {
        byte[] decoded = Base64.getDecoder().decode(key);
        PrivateKey priKey = KeyFactory.getInstance(RSA).generatePrivate(new PKCS8EncodedKeySpec(decoded));
        Cipher cipher = Cipher.getInstance(RSA);
        cipher.init(2, priKey);
        return new String(cipher.doFinal(encryptData));
    }

    @Override
    public String encrypt(String key, String data) throws Exception {
        byte[] decoded = Base64.getDecoder().decode(key);
        RSAPublicKey pubKey = (RSAPublicKey)KeyFactory.getInstance(RSA).generatePublic(new X509EncodedKeySpec(decoded));
        Cipher cipher = Cipher.getInstance(RSA);
        cipher.init(1, pubKey);
        return Base64.getEncoder().encodeToString(cipher.doFinal(data.getBytes(StandardCharsets.UTF_8)));
    }
}

