/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.rpc.init;

import com.weibo.api.motan.core.extension.ExtensionLoader;
import com.weibo.api.motan.rpc.init.Initializable;
import com.weibo.api.motan.util.LoggerUtil;
import java.util.List;

public class InitializationFactory {
    private static boolean inited = false;
    private static Initializable instance = new AllSpiInitialization();

    public static Initializable getInitialization() {
        return instance;
    }

    static class AllSpiInitialization
    implements Initializable {
        AllSpiInitialization() {
        }

        @Override
        public synchronized void init() {
            if (!inited) {
                try {
                    LoggerUtil.info("AllSpiInitialization init.");
                    ExtensionLoader<Initializable> extensionLoader = ExtensionLoader.getExtensionLoader(Initializable.class);
                    List<Initializable> allInit = extensionLoader.getExtensions(null);
                    if (allInit != null && !allInit.isEmpty()) {
                        for (Initializable initializable : allInit) {
                            try {
                                initializable.init();
                                LoggerUtil.info(initializable.getClass().getName() + " is init.");
                            }
                            catch (Exception initErr) {
                                LoggerUtil.error(initializable.getClass().getName() + " init fail!", initErr);
                            }
                        }
                    }
                    inited = true;
                    LoggerUtil.info("AllSpiInitialization init finish.");
                }
                catch (Exception e) {
                    LoggerUtil.error("Initializable spi init fail!", e);
                }
            }
        }
    }
}

