/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.toolkit.meter;

import java.util.Objects;
import org.apache.skywalking.apm.toolkit.meter.BaseMeter;
import org.apache.skywalking.apm.toolkit.meter.MeterId;

public abstract class BaseBuilder<BUILDER extends BaseBuilder, METER extends BaseMeter> {
    protected final MeterId meterId;

    public BaseBuilder(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Meter name cannot be null");
        }
        this.meterId = new MeterId(name, this.getType());
    }

    public BaseBuilder(MeterId meterId) {
        if (meterId == null) {
            throw new IllegalArgumentException("Meter id cannot be null");
        }
        if (!Objects.equals((Object)meterId.getType(), (Object)this.getType())) {
            throw new IllegalArgumentException("Meter id type is not matches");
        }
        this.meterId = meterId;
    }

    protected abstract MeterId.MeterType getType();

    protected abstract METER create();

    public BUILDER tag(String name, String value) {
        this.meterId.getTags().add(new MeterId.Tag(name, value));
        return (BUILDER)this;
    }

    public METER build() {
        this.meterId.getTags().sort(MeterId.Tag::compareTo);
        return this.create();
    }
}

