#
# Licensed to the Apache Software Foundation (ASF) under one or more
# contributor license agreements.  See the NOTICE file distributed with
# this work for additional information regarding copyright ownership.
# The ASF licenses this file to You under the Apache License, Version 2.0
# (the "License"); you may not use this file except in compliance with
# the License.  You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

import io
import logging
import traceback


class SWFormatter(logging.Formatter):
    """
    A slightly modified formatter that allows traceback depth
    """
    def __init__(self, fmt, tb_limit):
        logging.Formatter.__init__(self, fmt)
        self.tb_limit = tb_limit

    def formatException(self, ei):  # noqa
        """
        Format and return the specified exception information as a string.
        """
        sio = io.StringIO()
        tb = ei[2]
        traceback.print_exception(ei[0], ei[1], tb, self.tb_limit, sio)
        s = sio.getvalue()
        sio.close()
        if s[-1:] == '\n':
            s = s[:-1]
        return s

    def format(self, record):
        """
        Bypass cache so we don't disturb other Formatters
        """
        _exc_text = record.exc_text
        record.exc_text = None
        result = super(SWFormatter, self).format(record)
        record.exc_text = _exc_text

        return result
