/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.api.request.builder.impl;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.ListResourceBundle;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.servlet.RequestDispatcher;
import org.apache.felix.http.jakartawrappers.HttpServletRequestWrapper;
import org.apache.felix.http.jakartawrappers.RequestDispatcherWrapper;
import org.apache.felix.http.jakartawrappers.ServletContextWrapper;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingJakartaHttpServletRequest;
import org.apache.sling.api.request.RequestDispatcherOptions;
import org.apache.sling.api.request.RequestParameterMap;
import org.apache.sling.api.request.RequestPathInfo;
import org.apache.sling.api.request.RequestProgressTracker;
import org.apache.sling.api.request.builder.Builders;
import org.apache.sling.api.request.builder.SlingHttpServletRequestBuilder;
import org.apache.sling.api.request.builder.impl.HeaderSupport;
import org.apache.sling.api.request.builder.impl.ServletContextImpl;
import org.apache.sling.api.request.builder.impl.SlingHttpServletRequestImpl;
import org.apache.sling.api.request.builder.impl.SlingJakartaHttpServletRequestImpl;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.uri.SlingUriBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SlingHttpServletRequestBuilderImpl
implements SlingHttpServletRequestBuilder {
    private static final String DEFAULT_METHOD = "GET";
    static final String SECURE_PROTOCOL = "https";
    static final String HTTP_PROTOCOL = "http";
    static final String CHARSET_SEPARATOR = ";charset=";
    static final ResourceBundle EMPTY_RESOURCE_BUNDLE = new ListResourceBundle(){

        @Override
        protected Object[][] getContents() {
            return new Object[0][0];
        }
    };
    private static final String REQUEST = "request";
    final Resource resource;
    private String[] selectors;
    private String extension;
    private String suffix;
    String requestMethod = "GET";
    String contentType;
    String characterEncoding;
    String body;
    private boolean locked = false;
    final Map<String, String[]> parameters = new LinkedHashMap<String, String[]>();
    RequestPathInfo requestPathInfo;
    String queryString;
    String pathInfo;
    final Map<String, Object> attributeMap = new HashMap<String, Object>();
    HttpSession session;
    RequestParameterMap requestParameterMap;
    final HeaderSupport headerSupport = new HeaderSupport();
    final Map<String, Cookie> cookies = new LinkedHashMap<String, Cookie>();
    RequestProgressTracker progressTracker;
    HttpServletRequest sessionProvider;
    HttpServletRequest attributesProvider;
    ServletContext servletContext;
    SlingJakartaHttpServletRequest requestDispatcherProvider;
    boolean getInputStreamCalled;
    boolean getReaderCalled;
    final Locale locale = Locale.US;
    final String contextPath = "";
    final String scheme = "http";
    final String serverName = "localhost";
    final int serverPort = 80;
    String authType;
    String remoteUser;
    String remoteAddr;
    String remoteHost;
    int remotePort;
    String servletPath = "";
    String responseContentType;

    public SlingHttpServletRequestBuilderImpl(@NotNull Resource resource) {
        this.checkNotNull("resource", resource);
        this.resource = resource;
    }

    private void checkLocked() {
        if (this.locked) {
            throw new IllegalStateException("The builder can't be reused. Create a new builder instead.");
        }
    }

    private void checkNotNull(String info, Object candidate) {
        if (candidate == null) {
            throw new IllegalArgumentException(info.concat(" is null"));
        }
    }

    @Override
    @NotNull
    public SlingHttpServletRequestBuilder withRequestMethod(@NotNull String method) {
        this.checkLocked();
        this.checkNotNull("method", method);
        this.requestMethod = method.toUpperCase();
        return this;
    }

    @Override
    @NotNull
    public SlingHttpServletRequestBuilder withContentType(@Nullable String type) {
        int pos;
        this.checkLocked();
        int n = pos = type == null ? -1 : type.indexOf(CHARSET_SEPARATOR);
        if (pos != -1) {
            this.contentType = type.substring(0, pos);
            this.characterEncoding = type.substring(pos + CHARSET_SEPARATOR.length());
        } else {
            this.contentType = type;
        }
        return this;
    }

    @Override
    @NotNull
    public SlingHttpServletRequestBuilder withBody(@Nullable String content) {
        this.checkLocked();
        this.body = content;
        return this;
    }

    @Override
    @NotNull
    public SlingHttpServletRequestBuilder withSelectors(String ... selectors) {
        this.checkLocked();
        this.selectors = selectors;
        return this;
    }

    @Override
    @NotNull
    public SlingHttpServletRequestBuilder withExtension(String extension) {
        this.checkLocked();
        this.extension = extension;
        return this;
    }

    @Override
    @NotNull
    public SlingHttpServletRequestBuilder withSuffix(String suffix) {
        this.checkLocked();
        this.suffix = suffix;
        return this;
    }

    @Override
    @NotNull
    public SlingHttpServletRequestBuilder withParameter(@NotNull String key, @NotNull String value) {
        this.checkLocked();
        this.checkNotNull("key", key);
        this.checkNotNull("value", value);
        this.parameters.put(key, new String[]{value});
        return this;
    }

    @Override
    @NotNull
    public SlingHttpServletRequestBuilder withParameter(@NotNull String key, @NotNull String[] values) {
        this.checkLocked();
        this.checkNotNull("key", key);
        this.checkNotNull("values", values);
        this.parameters.put(key, values);
        return this;
    }

    @Override
    @NotNull
    public SlingHttpServletRequestBuilder withParameters(@Nullable Map<String, String[]> parameters) {
        this.checkLocked();
        if (parameters != null) {
            this.parameters.putAll(parameters);
        }
        return this;
    }

    @Override
    @NotNull
    public SlingHttpServletRequestBuilder useAttributesFrom(@NotNull javax.servlet.http.HttpServletRequest request) {
        this.checkLocked();
        this.checkNotNull(REQUEST, request);
        this.attributesProvider = new HttpServletRequestWrapper(request);
        return this;
    }

    @Override
    @NotNull
    public SlingHttpServletRequestBuilder useServletContextFrom(@NotNull javax.servlet.http.HttpServletRequest request) {
        this.checkLocked();
        this.checkNotNull(REQUEST, request);
        this.servletContext = new ServletContextWrapper(request.getServletContext());
        return this;
    }

    @Override
    @NotNull
    public SlingHttpServletRequestBuilder useSessionFrom(@NotNull javax.servlet.http.HttpServletRequest request) {
        this.checkLocked();
        this.checkNotNull(REQUEST, request);
        this.sessionProvider = new HttpServletRequestWrapper(request);
        return this;
    }

    @Override
    @Deprecated
    @NotNull
    public SlingHttpServletRequestBuilder useRequestDispatcherFrom(final @NotNull SlingHttpServletRequest request) {
        this.checkLocked();
        this.checkNotNull(REQUEST, request);
        this.requestDispatcherProvider = new SlingJakartaHttpServletRequestImpl(this){

            @Override
            public jakarta.servlet.RequestDispatcher getRequestDispatcher(String path) {
                RequestDispatcher dispatcher = request.getRequestDispatcher(path);
                if (dispatcher != null) {
                    return new RequestDispatcherWrapper(dispatcher);
                }
                return null;
            }

            @Override
            public jakarta.servlet.RequestDispatcher getRequestDispatcher(String path, RequestDispatcherOptions options) {
                RequestDispatcher dispatcher = request.getRequestDispatcher(path, options);
                if (dispatcher != null) {
                    return new RequestDispatcherWrapper(dispatcher);
                }
                return null;
            }

            @Override
            public jakarta.servlet.RequestDispatcher getRequestDispatcher(Resource resource) {
                RequestDispatcher dispatcher = request.getRequestDispatcher(resource);
                if (dispatcher != null) {
                    return new RequestDispatcherWrapper(dispatcher);
                }
                return null;
            }

            @Override
            public jakarta.servlet.RequestDispatcher getRequestDispatcher(Resource resource, RequestDispatcherOptions options) {
                RequestDispatcher dispatcher = request.getRequestDispatcher(resource, options);
                if (dispatcher != null) {
                    return new RequestDispatcherWrapper(dispatcher);
                }
                return null;
            }
        };
        return this;
    }

    @Override
    @NotNull
    public SlingHttpServletRequestBuilder useAttributesFrom(@NotNull HttpServletRequest request) {
        this.checkLocked();
        this.checkNotNull(REQUEST, request);
        this.attributesProvider = request;
        return this;
    }

    @Override
    @NotNull
    public SlingHttpServletRequestBuilder useServletContextFrom(@NotNull HttpServletRequest request) {
        this.checkLocked();
        this.checkNotNull(REQUEST, request);
        this.servletContext = request.getServletContext();
        return this;
    }

    @Override
    @NotNull
    public SlingHttpServletRequestBuilder useSessionFrom(@NotNull HttpServletRequest request) {
        this.checkLocked();
        this.checkNotNull(REQUEST, request);
        this.sessionProvider = request;
        return this;
    }

    @Override
    @NotNull
    public SlingHttpServletRequestBuilder useRequestDispatcherFrom(@NotNull SlingJakartaHttpServletRequest request) {
        this.checkLocked();
        this.checkNotNull(REQUEST, request);
        this.requestDispatcherProvider = request;
        return this;
    }

    @Override
    @NotNull
    public SlingHttpServletRequestBuilder withRequestProgressTracker(@NotNull RequestProgressTracker tracker) {
        this.progressTracker = tracker;
        return this;
    }

    @Override
    @Deprecated
    @NotNull
    public SlingHttpServletRequest build() {
        this.checkLocked();
        this.locked = true;
        this.requestPathInfo = SlingUriBuilder.createFrom(this.resource).setExtension(this.extension).setSuffix(this.suffix).setSelectors(this.selectors).build();
        this.queryString = this.formatQueryString();
        this.pathInfo = this.buildPathInfo();
        if (this.servletContext == null) {
            this.servletContext = new ServletContextImpl();
        }
        if (this.body == null) {
            this.body = "";
        }
        SlingHttpServletRequestImpl req = new SlingHttpServletRequestImpl(this);
        if (this.progressTracker == null) {
            Object attrTracker = req.getAttribute(RequestProgressTracker.class.getName());
            this.progressTracker = attrTracker instanceof RequestProgressTracker ? (RequestProgressTracker)attrTracker : Builders.newRequestProgressTracker();
        }
        return req;
    }

    @Override
    @NotNull
    public SlingJakartaHttpServletRequest buildJakartaRequest() {
        this.checkLocked();
        this.locked = true;
        this.requestPathInfo = SlingUriBuilder.createFrom(this.resource).setExtension(this.extension).setSuffix(this.suffix).setSelectors(this.selectors).build();
        this.queryString = this.formatQueryString();
        this.pathInfo = this.buildPathInfo();
        if (this.servletContext == null) {
            this.servletContext = new ServletContextImpl();
        }
        if (this.body == null) {
            this.body = "";
        }
        SlingJakartaHttpServletRequestImpl req = new SlingJakartaHttpServletRequestImpl(this);
        if (this.progressTracker == null) {
            Object attrTracker = req.getAttribute(RequestProgressTracker.class.getName());
            this.progressTracker = attrTracker instanceof RequestProgressTracker ? (RequestProgressTracker)attrTracker : Builders.newRequestProgressTracker();
        }
        return req;
    }

    private String buildPathInfo() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.requestPathInfo.getResourcePath());
        if (this.requestPathInfo.getSelectorString() != null) {
            builder.append('.');
            builder.append(this.requestPathInfo.getSelectorString());
        }
        if (this.requestPathInfo.getExtension() != null) {
            builder.append('.');
            builder.append(this.requestPathInfo.getExtension());
        }
        if (this.requestPathInfo.getSuffix() != null) {
            builder.append(this.requestPathInfo.getSuffix());
        }
        return builder.toString();
    }

    private String formatQueryString() {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, String[]> entry : this.parameters.entrySet()) {
            if (entry.getValue() == null) continue;
            SlingHttpServletRequestBuilderImpl.formatQueryStringParameter(builder, entry);
        }
        return builder.length() > 0 ? builder.toString() : null;
    }

    private static String encode(String v) {
        try {
            return URLEncoder.encode(v, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException uee) {
            return v;
        }
    }

    private static void formatQueryStringParameter(StringBuilder builder, Map.Entry<String, String[]> entry) {
        for (String value : entry.getValue()) {
            if (builder.length() != 0) {
                builder.append('&');
            }
            builder.append(SlingHttpServletRequestBuilderImpl.encode(entry.getKey()));
            builder.append('=');
            if (value == null) continue;
            builder.append(SlingHttpServletRequestBuilderImpl.encode(value));
        }
    }
}

