/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.auth.xing.oauth.impl;

import java.util.Dictionary;
import javax.jcr.Credentials;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.auth.xing.api.AbstractXingUserManager;
import org.apache.sling.auth.xing.api.XingUser;
import org.apache.sling.auth.xing.oauth.XingOauthUserManager;
import org.apache.sling.auth.xing.oauth.XingOauthUtil;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.jcr.api.SlingRepository;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(label="Apache Sling Authentication XING OAuth \u201cDefault User Manager\u201d", description="Default User Manager for Sling Authentication XING OAuth", immediate=true, metatype=true)
@Service
@Properties(value={@Property(name="service.vendor", value={"The Apache Software Foundation"}), @Property(name="service.description", value={"Default User Manager for Sling Authentication XING OAuth"}), @Property(name="service.ranking", intValue={0}, propertyPrivate=false)})
public class DefaultXingOauthUserManager
extends AbstractXingUserManager
implements XingOauthUserManager {
    @Reference
    private SlingRepository slingRepository;
    private static final String FIRSTNAME_PROPERTY = "firstname";
    private static final String LASTNAME_PROPERTY = "lastname";
    @Property(boolValue={true})
    private static final String AUTO_CREATE_USER_PARAMETER = "org.apache.sling.auth.xing.oauth.impl.DefaultXingOauthUserManager.user.create.auto";
    @Property(boolValue={false})
    private static final String AUTO_UPDATE_USER_PARAMETER = "org.apache.sling.auth.xing.oauth.impl.DefaultXingOauthUserManager.user.update.auto";
    private final Logger logger = LoggerFactory.getLogger(DefaultXingOauthUserManager.class);

    @Activate
    protected void activate(ComponentContext componentContext) {
        this.logger.debug("activate");
        this.configure(componentContext);
    }

    @Modified
    protected void modified(ComponentContext componentContext) {
        this.logger.debug("modified");
        this.configure(componentContext);
    }

    @Deactivate
    protected void deactivate(ComponentContext componentContext) {
        this.logger.debug("deactivate");
        if (this.session != null) {
            this.session.logout();
            this.session = null;
        }
    }

    protected synchronized void configure(ComponentContext componentContext) {
        Dictionary properties = componentContext.getProperties();
        this.autoCreateUser = PropertiesUtil.toBoolean(properties.get(AUTO_CREATE_USER_PARAMETER), true);
        this.autoUpdateUser = PropertiesUtil.toBoolean(properties.get(AUTO_UPDATE_USER_PARAMETER), false);
    }

    protected SlingRepository getSlingRepository() {
        return this.slingRepository;
    }

    public User createUser(Credentials credentials) {
        this.logger.debug("create user");
        XingUser xingUser = XingOauthUtil.getXingUser(credentials);
        if (xingUser == null) {
            return null;
        }
        try {
            String userId = xingUser.getId();
            Session session = this.getSession();
            UserManager userManager = this.getUserManager(session);
            User user = userManager.createUser(userId, null);
            ValueFactory valueFactory = session.getValueFactory();
            Value firstnameValue = valueFactory.createValue(xingUser.getFirstName());
            Value lastnameValue = valueFactory.createValue(xingUser.getLastName());
            user.setProperty(FIRSTNAME_PROPERTY, firstnameValue);
            user.setProperty(LASTNAME_PROPERTY, lastnameValue);
            session.save();
            return user;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public User updateUser(Credentials credentials) {
        this.logger.debug("update user");
        XingUser xingUser = XingOauthUtil.getXingUser(credentials);
        if (xingUser == null) {
            return null;
        }
        try {
            Session session = this.getSession();
            User user = this.getUser(credentials);
            ValueFactory valueFactory = session.getValueFactory();
            boolean firstnameUpdated = this.updateUserProperty(user, valueFactory, FIRSTNAME_PROPERTY, xingUser.getFirstName());
            boolean lastnameUpdated = this.updateUserProperty(user, valueFactory, LASTNAME_PROPERTY, xingUser.getLastName());
            if (firstnameUpdated || lastnameUpdated) {
                session.save();
            }
            return user;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private boolean updateUserProperty(User user, ValueFactory valueFactory, String property, String string) throws RepositoryException {
        Value[] values = user.getProperty(property);
        if (values != null && values.length > 0 && string.equals(values[0].getString())) {
            return false;
        }
        Value value = valueFactory.createValue(string);
        user.setProperty(property, value);
        return true;
    }

    protected void bindSlingRepository(SlingRepository slingRepository) {
        this.slingRepository = slingRepository;
    }

    protected void unbindSlingRepository(SlingRepository slingRepository) {
        if (this.slingRepository == slingRepository) {
            this.slingRepository = null;
        }
    }
}

