/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.auth.xing.oauth.impl;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.util.Dictionary;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyUnbounded;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.auth.core.spi.AuthenticationHandler;
import org.apache.sling.auth.core.spi.AuthenticationInfo;
import org.apache.sling.auth.core.spi.DefaultAuthenticationFeedbackHandler;
import org.apache.sling.auth.xing.api.XingUser;
import org.apache.sling.auth.xing.api.users.Users;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.osgi.service.component.ComponentContext;
import org.scribe.builder.ServiceBuilder;
import org.scribe.builder.api.XingApi;
import org.scribe.model.OAuthRequest;
import org.scribe.model.Response;
import org.scribe.model.Token;
import org.scribe.model.Verb;
import org.scribe.model.Verifier;
import org.scribe.oauth.OAuthService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(label="Apache Sling Authentication XING OAuth \u201cAuthentication Handler\u201d", description="Authentication Handler for Sling Authentication XING OAuth", immediate=true, metatype=true)
@Service
@Properties(value={@Property(name="service.vendor", value={"The Apache Software Foundation"}), @Property(name="service.description", value={"Authentication Handler for Sling Authentication XING OAuth"}), @Property(name="service.ranking", intValue={0}, propertyPrivate=false), @Property(name="path", value={"/"}, unbounded=PropertyUnbounded.ARRAY), @Property(name="authtype", value={"xing-oauth"}, propertyPrivate=true)})
public class XingOauthAuthenticationHandler
extends DefaultAuthenticationFeedbackHandler
implements AuthenticationHandler {
    private OAuthService oAuthService;
    private String consumerKey;
    private String consumerSecret;
    private String callbackUrl;
    private String usersMeUrl;
    private static final String DEFAULT_USERS_ME_URL = "https://api.xing.com/v1/users/me.json";
    @Property(value={""})
    private static final String CONSUMER_KEY_PARAMETER = "org.apache.sling.auth.xing.oauth.impl.XingOauthAuthenticationHandler.consumerKey";
    @Property(value={""})
    private static final String CONSUMER_SECRET_PARAMETER = "org.apache.sling.auth.xing.oauth.impl.XingOauthAuthenticationHandler.consumerSecret";
    @Property(value={""})
    private static final String CALLBACK_URL_PARAMETER = "org.apache.sling.auth.xing.oauth.impl.XingOauthAuthenticationHandler.callbackUrl";
    @Property(value={"https://api.xing.com/v1/users/me.json"})
    private static final String USERS_ME_URL_PARAMETER = "org.apache.sling.auth.xing.oauth.impl.XingOauthAuthenticationHandler.usersMeUrl";
    public static final String USER_SESSION_ATTRIBUTE_NAME = "xing-user";
    private final Logger logger = LoggerFactory.getLogger(XingOauthAuthenticationHandler.class);

    @Activate
    protected void activate(ComponentContext componentContext) {
        this.logger.debug("activate");
        this.configure(componentContext);
    }

    @Modified
    protected void modified(ComponentContext componentContext) {
        this.logger.debug("modified");
        this.configure(componentContext);
    }

    @Deactivate
    protected void deactivate(ComponentContext componentContext) {
        this.logger.debug("deactivate");
    }

    protected synchronized void configure(ComponentContext componentContext) {
        Dictionary properties = componentContext.getProperties();
        this.consumerKey = PropertiesUtil.toString(properties.get(CONSUMER_KEY_PARAMETER), "").trim();
        this.consumerSecret = PropertiesUtil.toString(properties.get(CONSUMER_SECRET_PARAMETER), "").trim();
        this.callbackUrl = PropertiesUtil.toString(properties.get(CALLBACK_URL_PARAMETER), "").trim();
        this.usersMeUrl = PropertiesUtil.toString(properties.get(USERS_ME_URL_PARAMETER), DEFAULT_USERS_ME_URL).trim();
        if (StringUtils.isEmpty((String)this.consumerKey)) {
            this.logger.warn("configured consumer key is empty");
        }
        if (StringUtils.isEmpty((String)this.consumerSecret)) {
            this.logger.warn("configured consumer secret is empty");
        }
        if (StringUtils.isEmpty((String)this.callbackUrl)) {
            this.logger.warn("configured callback URL is empty");
        }
        if (StringUtils.isEmpty((String)this.usersMeUrl)) {
            this.logger.warn("configured users me URL is empty");
        }
        this.oAuthService = !StringUtils.isEmpty((String)this.consumerKey) && !StringUtils.isEmpty((String)this.consumerSecret) && !StringUtils.isEmpty((String)this.callbackUrl) ? new ServiceBuilder().provider(XingApi.class).apiKey(this.consumerKey).apiSecret(this.consumerSecret).callback(this.callbackUrl).build() : null;
        this.logger.info("configured with consumer key '{}', callback url '{}' and users me url '{}'", new Object[]{this.consumerKey, this.callbackUrl, this.usersMeUrl});
    }

    public AuthenticationInfo extractCredentials(HttpServletRequest request, HttpServletResponse response) {
        this.logger.debug("extract credentials");
        if (this.oAuthService == null) {
            this.logger.error("OAuthService is null, check configuration");
            return null;
        }
        try {
            HttpSession httpSession = request.getSession(true);
            Token accessToken = (Token)httpSession.getAttribute("access_token");
            XingUser xingUser = (XingUser)httpSession.getAttribute(USER_SESSION_ATTRIBUTE_NAME);
            if (accessToken == null) {
                Token requestToken = (Token)httpSession.getAttribute("oauth_token");
                String verifier = request.getParameter("oauth_verifier");
                if (requestToken == null || verifier == null) {
                    return null;
                }
                accessToken = this.oAuthService.getAccessToken(requestToken, new Verifier(verifier));
                this.logger.debug("access token: {}", (Object)accessToken);
                httpSession.setAttribute("access_token", (Object)accessToken);
            }
            if (xingUser == null) {
                xingUser = this.fetchUser(accessToken);
                this.logger.debug("xing user: {}", (Object)xingUser);
                httpSession.setAttribute(USER_SESSION_ATTRIBUTE_NAME, (Object)xingUser);
            }
            AuthenticationInfo authenticationInfo = new AuthenticationInfo("xing-oauth", xingUser.getId());
            authenticationInfo.put("xing-access-token", (Object)accessToken);
            authenticationInfo.put(USER_SESSION_ATTRIBUTE_NAME, (Object)xingUser);
            return authenticationInfo;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            this.removeAuthFromSession(request);
            return null;
        }
    }

    public boolean requestCredentials(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.logger.debug("request credentials");
        if (this.oAuthService == null) {
            this.logger.error("OAuthService is null, check configuration");
            return false;
        }
        try {
            Token requestToken = this.oAuthService.getRequestToken();
            this.logger.debug("received request token: '{}'", (Object)requestToken);
            HttpSession httpSession = request.getSession(true);
            httpSession.setAttribute("oauth_token", (Object)requestToken);
            String authUrl = this.oAuthService.getAuthorizationUrl(requestToken);
            this.logger.debug("redirecting to auth url: '{}'", (Object)authUrl);
            response.sendRedirect(authUrl);
            return true;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public void dropCredentials(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.logger.debug("drop credentials");
        this.removeAuthFromSession(request);
    }

    protected XingUser fetchUser(Token accessToken) throws Exception {
        OAuthRequest request = new OAuthRequest(Verb.GET, this.usersMeUrl);
        this.oAuthService.signRequest(accessToken, request);
        Response response = request.send();
        Gson gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();
        Users users = gson.fromJson(response.getBody(), Users.class);
        return (XingUser)users.getUsers().get(0);
    }

    protected void removeAuthFromSession(HttpServletRequest request) {
        try {
            HttpSession httpSession = request.getSession();
            httpSession.removeAttribute("oauth_token");
            httpSession.removeAttribute("access_token");
            httpSession.removeAttribute(USER_SESSION_ATTRIBUTE_NAME);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

