/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.reference.forms.impl.actions;

import java.util.Arrays;
import java.util.Calendar;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.cms.reference.forms.FormAction;
import org.apache.sling.cms.reference.forms.FormActionResult;
import org.apache.sling.cms.reference.forms.FormException;
import org.apache.sling.cms.reference.forms.FormRequest;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={FormAction.class})
public class UpdateProfileAction
implements FormAction {
    public static final String RESOURCE_TYPE = "reference/components/forms/actions/updateprofile";
    private static final Logger log = LoggerFactory.getLogger(UpdateProfileAction.class);

    @Override
    public FormActionResult handleForm(Resource actionResource, FormRequest request) throws FormException {
        ResourceResolver resolver = request.getOriginalRequest().getResourceResolver();
        String userId = resolver.getUserID();
        try {
            JackrabbitSession session = Optional.ofNullable((JackrabbitSession)resolver.adaptTo(Session.class)).orElseThrow(() -> new RepositoryException("Unable to get Jackrabbit Session"));
            UserManager userManager = session.getUserManager();
            if (userManager.getAuthorizable(userId) == null) {
                log.warn("No profile found for {}", (Object)userId);
                return FormActionResult.failure("No profile found for " + userId);
            }
            User user = (User)userManager.getAuthorizable(userId);
            log.debug("Updating profile for {}", (Object)userId);
            String subpath = (String)actionResource.getValueMap().get("subpath", (Object)"profile");
            ValueFactory valueFactory = session.getValueFactory();
            for (Map.Entry e : request.getFormData().entrySet()) {
                Value value = null;
                if (e.getValue() instanceof String[]) {
                    Value[] values = Arrays.stream((String[])e.getValue()).map(arg_0 -> ((ValueFactory)valueFactory).createValue(arg_0)).collect(Collectors.toList()).toArray(new Value[0]);
                    user.setProperty(subpath + "/" + (String)e.getKey(), values);
                    continue;
                }
                value = e.getValue() instanceof Calendar ? valueFactory.createValue((Calendar)e.getValue()) : (e.getValue() instanceof Double ? valueFactory.createValue(((Double)e.getValue()).doubleValue()) : (e.getValue() instanceof Integer ? valueFactory.createValue((long)((Integer)e.getValue()).intValue()) : valueFactory.createValue((String)e.getValue())));
                user.setProperty(subpath + "/" + (String)e.getKey(), value);
            }
            log.debug("Saving changes!");
            resolver.commit();
            return FormActionResult.success("Profile Updated");
        }
        catch (RepositoryException | PersistenceException e) {
            log.warn("Failed to update profile for {}", (Object)userId, (Object)e);
            return FormActionResult.failure("Failed to update profile for " + userId);
        }
    }

    @Override
    public boolean handles(Resource actionResource) {
        return RESOURCE_TYPE.equals(actionResource.getResourceType());
    }
}

