/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.reference.forms.impl.providers;

import java.util.Arrays;
import java.util.Map;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.cms.reference.forms.FormValueProvider;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={FormValueProvider.class})
public class RequestParametersValueProvider
implements FormValueProvider {
    private static final Logger log = LoggerFactory.getLogger(RequestParametersValueProvider.class);

    @Override
    public void loadValues(SlingHttpServletRequest request, Resource providerResource, Map<String, Object> formData) {
        log.trace("loadFormData");
        String[] parameters = (String[])providerResource.getValueMap().get("allowedParameters", String[].class);
        if (parameters != null) {
            Arrays.stream(parameters).forEach(p -> {
                if (request.getParameter(p) != null) {
                    if (request.getParameterValues(p).length > 1) {
                        formData.put((String)p, request.getParameterValues(p));
                    } else {
                        formData.put((String)p, request.getParameter(p));
                    }
                }
            });
        }
    }

    @Override
    public boolean handles(Resource valueProviderResource) {
        return "reference/components/forms/providers/requestparameters".equals(valueProviderResource.getResourceType());
    }
}

