/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.metrics.internal;

import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

final class JmxUtil {
    JmxUtil() {
    }

    public static String quoteValueIfRequired(String unquotedValue) {
        String result;
        String quotedValue = ObjectName.quote(unquotedValue);
        if (quotedValue.substring(1, quotedValue.length() - 1).equals(unquotedValue)) {
            ObjectName on = null;
            try {
                on = new ObjectName("dummy", "dummy", unquotedValue);
            }
            catch (MalformedObjectNameException malformedObjectNameException) {
                // empty catch block
            }
            result = on != null ? unquotedValue : quotedValue;
        } else {
            result = quotedValue;
        }
        return result;
    }

    public static String safeDomainName(String name) {
        if (name == null) {
            return null;
        }
        name = name.trim();
        name = name.replace(':', '_');
        name = name.replace('*', '_');
        name = name.replace('?', '_');
        name = name.replace('\n', '_');
        return name;
    }
}

