/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.threads.impl;

import java.io.PrintWriter;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.sling.commons.threads.ThreadPoolConfig;
import org.apache.sling.commons.threads.impl.DefaultThreadPoolManager;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class WebConsolePrinter {
    private static ServiceRegistration plugin;
    private static String HEADLINE;
    private final DefaultThreadPoolManager mgr;

    public static void initPlugin(BundleContext bundleContext, DefaultThreadPoolManager dtpm) {
        WebConsolePrinter propertiesPrinter = new WebConsolePrinter(dtpm);
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("service.description", "Apache Sling Thread Pool Configuration Printer");
        ((Dictionary)props).put("service.vendor", "The Apache Software Foundation");
        ((Dictionary)props).put("felix.webconsole.label", "slingthreadpools");
        ((Dictionary)props).put("felix.webconsole.title", "Sling Thread Pools");
        ((Dictionary)props).put("felix.webconsole.configprinter.modes", "always");
        plugin = bundleContext.registerService(WebConsolePrinter.class.getName(), (Object)propertiesPrinter, props);
    }

    public static void destroyPlugin() {
        if (plugin != null) {
            plugin.unregister();
            plugin = null;
        }
    }

    public WebConsolePrinter(DefaultThreadPoolManager dtpm) {
        this.mgr = dtpm;
    }

    public void printConfiguration(PrintWriter pw) {
        pw.println(HEADLINE);
        pw.println();
        DefaultThreadPoolManager.Entry[] configs = this.mgr.getConfigurations();
        if (configs.length > 0) {
            for (DefaultThreadPoolManager.Entry entry : configs) {
                ThreadPoolConfig config = entry.getConfig();
                pw.print("Pool ");
                pw.println(entry.getName());
                if (entry.getPid() != null) {
                    pw.print("- from configuration : ");
                    pw.println(entry.getPid());
                }
                pw.print("- used : ");
                pw.println(entry.isUsed());
                pw.print("- min pool size : ");
                pw.println(config.getMinPoolSize());
                pw.print("- max pool size : ");
                pw.println(config.getMaxPoolSize());
                pw.print("- queue size : ");
                pw.println(config.getQueueSize());
                pw.print("- keep alive time : ");
                pw.println(config.getKeepAliveTime());
                pw.print("- block policy : ");
                pw.println((Object)config.getBlockPolicy());
                pw.print("- priority : ");
                pw.println((Object)config.getPriority());
                pw.print("- shutdown graceful : ");
                pw.println(config.isShutdownGraceful());
                pw.print("- shutdown wait time : ");
                pw.println(config.getShutdownWaitTimeMs());
                pw.print("- daemon : ");
                pw.println(config.isDaemon());
                ThreadPoolExecutor tpe = entry.getExecutor();
                if (tpe != null) {
                    pw.print("- active count : ");
                    pw.println(tpe.getActiveCount());
                    pw.print("- completed task count : ");
                    pw.println(tpe.getCompletedTaskCount());
                    pw.print("- core pool size : ");
                    pw.println(tpe.getCorePoolSize());
                    pw.print("- largest pool size : ");
                    pw.println(tpe.getLargestPoolSize());
                    pw.print("- maximum pool size : ");
                    pw.println(tpe.getMaximumPoolSize());
                    pw.print("- pool size : ");
                    pw.println(tpe.getPoolSize());
                    pw.print("- task count : ");
                    pw.println(tpe.getTaskCount());
                }
                pw.println();
            }
        } else {
            pw.println("No pools configured.");
        }
    }

    static {
        HEADLINE = "Apache Sling Thread Pools";
    }
}

