/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.crankstart.testservices;

import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.crankstart.api.CrankstartCommand;
import org.apache.sling.crankstart.api.CrankstartCommandLine;
import org.apache.sling.crankstart.api.CrankstartContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service
public class SystemPropertyCommand
implements CrankstartCommand {
    public static final String I_SYSTEM_PROPERTY = "test.system.property";
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public boolean appliesTo(CrankstartCommandLine commandLine) {
        return I_SYSTEM_PROPERTY.equals(commandLine.getVerb());
    }

    public String getDescription() {
        return "test.system.property: set a system property";
    }

    public void execute(CrankstartContext crankstartContext, CrankstartCommandLine commandLine) throws Exception {
        String[] parts = commandLine.getQualifier().split(" ");
        String key = parts[0];
        StringBuilder sb = new StringBuilder();
        for (int i = 1; i < parts.length; ++i) {
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(parts[i]);
        }
        String value = sb.toString();
        System.setProperty(key, value);
        this.log.info("System property [{}] set to [{}]", (Object)key, (Object)value);
    }
}

