/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.packaging.impl.importer;

import java.io.InputStream;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.distribution.common.DistributionException;
import org.apache.sling.distribution.event.impl.DistributionEventFactory;
import org.apache.sling.distribution.packaging.DistributionPackage;
import org.apache.sling.distribution.packaging.DistributionPackageBuilder;
import org.apache.sling.distribution.packaging.DistributionPackageInfo;
import org.apache.sling.distribution.packaging.impl.DistributionPackageImporter;
import org.apache.sling.distribution.packaging.impl.importer.LocalDistributionPackageImporter;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@Component(service={DistributionPackageImporter.class}, configurationPolicy=ConfigurationPolicy.REQUIRE, property={"webconsole.configurationFactory.nameHint=Importer name: {name}"})
@Designate(ocd=Config.class, factory=true)
public class LocalDistributionPackageImporterFactory
implements DistributionPackageImporter {
    @Reference(name="packageBuilder")
    private DistributionPackageBuilder packageBuilder;
    @Reference
    private DistributionEventFactory eventFactory;
    private DistributionPackageImporter importer;

    @Activate
    public void activate(Config conf) {
        String name = conf.name();
        this.importer = new LocalDistributionPackageImporter(name, this.eventFactory, this.packageBuilder);
    }

    @Override
    public void importPackage(@NotNull ResourceResolver resourceResolver, @NotNull DistributionPackage distributionPackage) throws DistributionException {
        this.importer.importPackage(resourceResolver, distributionPackage);
    }

    @Override
    @NotNull
    public DistributionPackageInfo importStream(@NotNull ResourceResolver resourceResolver, @NotNull InputStream stream) throws DistributionException {
        return this.importer.importStream(resourceResolver, stream);
    }

    @ObjectClassDefinition(name="Apache Sling Distribution Importer - Local Package Importer Factory")
    public static @interface Config {
        @AttributeDefinition(name="Name", description="THe name of the importer.")
        public String name();

        @AttributeDefinition(name="Package Builder", description="The target reference for the DistributionPackageBuilder used to create distribution packages, e.g. use target=(name=...) to bind to services by name.")
        public String packageBuilder_target() default "(name=default)";
    }
}

