/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.serialization.impl;

import java.util.List;
import org.apache.sling.distribution.component.impl.DistributionComponent;
import org.apache.sling.distribution.component.impl.DistributionComponentKind;
import org.apache.sling.distribution.component.impl.DistributionComponentProvider;
import org.apache.sling.distribution.packaging.DistributionPackageBuilder;
import org.apache.sling.distribution.packaging.impl.DistributionPackageBuilderProvider;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={DistributionPackageBuilderProvider.class})
public class DefaultDistributionPackageBuilderProvider
implements DistributionPackageBuilderProvider {
    @Reference
    private DistributionComponentProvider componentProvider;

    @Override
    public DistributionPackageBuilder getPackageBuilder(String type) {
        List<DistributionComponent<?>> componentList = this.componentProvider.getComponents(DistributionComponentKind.PACKAGE_BUILDER);
        return DefaultDistributionPackageBuilderProvider.filterPackageBuildersByType(componentList, type);
    }

    private static DistributionPackageBuilder filterPackageBuildersByType(List<DistributionComponent<?>> componentList, String type) {
        if (type == null) {
            return null;
        }
        for (DistributionComponent<?> component : componentList) {
            DistributionPackageBuilder packageBuilder;
            Object service = component.getService();
            if (!(service instanceof DistributionPackageBuilder) || !type.equals((packageBuilder = (DistributionPackageBuilder)service).getType())) continue;
            return packageBuilder;
        }
        return null;
    }
}

