/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.serialization.impl;

import java.io.InputStream;
import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.distribution.DistributionRequest;
import org.apache.sling.distribution.common.DistributionException;
import org.apache.sling.distribution.component.impl.SettingsUtils;
import org.apache.sling.distribution.monitor.impl.MonitoringDistributionPackageBuilder;
import org.apache.sling.distribution.packaging.DistributionPackage;
import org.apache.sling.distribution.packaging.DistributionPackageBuilder;
import org.apache.sling.distribution.packaging.DistributionPackageInfo;
import org.apache.sling.distribution.packaging.impl.AbstractDistributionPackageBuilder;
import org.apache.sling.distribution.packaging.impl.FileDistributionPackageBuilder;
import org.apache.sling.distribution.packaging.impl.InMemoryDistributionPackageBuilder;
import org.apache.sling.distribution.packaging.impl.ResourceDistributionPackageBuilder;
import org.apache.sling.distribution.packaging.impl.ResourceDistributionPackageCleanup;
import org.apache.sling.distribution.serialization.DistributionContentSerializer;
import org.apache.sling.distribution.util.impl.FileBackedMemoryOutputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.osgi.service.metatype.annotations.Option;

@Component(configurationPolicy=ConfigurationPolicy.REQUIRE, service={DistributionPackageBuilder.class}, property={"webconsole.configurationFactory.nameHint=Builder name: {name}"})
@Designate(ocd=Config.class, factory=true)
public class DistributionPackageBuilderFactory
implements DistributionPackageBuilder {
    private MonitoringDistributionPackageBuilder packageBuilder;
    private ServiceRegistration<Runnable> packageCleanup = null;
    @Reference(name="format")
    private DistributionContentSerializer contentSerializer;
    @Reference
    private ResourceResolverFactory resolverFactory;
    private static final int DEFAULT_FILE_THRESHOLD_VALUE = 1;
    private static final String DEFAULT_MEMORY_UNIT = "MEGA_BYTES";
    private static final boolean DEFAULT_USE_OFF_HEAP_MEMORY = false;
    private static final String DEFAULT_DIGEST_ALGORITHM = "NONE";
    private static final int DEFAULT_MONITORING_QUEUE_SIZE = 0;
    private static final long DEFAULT_PACKAGE_CLEANUP_DELAY = 60L;

    @Activate
    public void activate(BundleContext context, Config conf) {
        AbstractDistributionPackageBuilder wrapped;
        String[] nodeFilters = SettingsUtils.removeEmptyEntries(conf.package_filters());
        String[] propertyFilters = SettingsUtils.removeEmptyEntries(conf.property_filters());
        String persistenceType = conf.type();
        String tempFsFolder = SettingsUtils.removeEmptyEntry(conf.tempFsFolder());
        String digestAlgorithm = conf.digestAlgorithm();
        long cleanupDelay = conf.cleanupDelay();
        if (DEFAULT_DIGEST_ALGORITHM.equals(digestAlgorithm)) {
            digestAlgorithm = null;
        }
        if ("file".equals(persistenceType)) {
            wrapped = new FileDistributionPackageBuilder(this.contentSerializer.getName(), this.contentSerializer, tempFsFolder, digestAlgorithm, nodeFilters, propertyFilters);
        } else if ("inmemory".equals(persistenceType)) {
            wrapped = new InMemoryDistributionPackageBuilder(this.contentSerializer.getName(), this.contentSerializer, nodeFilters, propertyFilters);
        } else {
            int fileThreshold = conf.fileThreshold();
            String memoryUnitName = conf.memoryUnit();
            FileBackedMemoryOutputStream.MemoryUnit memoryUnit = FileBackedMemoryOutputStream.MemoryUnit.valueOf(memoryUnitName);
            boolean useOffHeapMemory = conf.useOffHeapMemory();
            ResourceDistributionPackageBuilder resourceDistributionPackageBuilder = new ResourceDistributionPackageBuilder(this.contentSerializer.getName(), this.contentSerializer, tempFsFolder, fileThreshold, memoryUnit, useOffHeapMemory, digestAlgorithm, nodeFilters, propertyFilters);
            ResourceDistributionPackageCleanup cleanup = new ResourceDistributionPackageCleanup(this.resolverFactory, resourceDistributionPackageBuilder);
            Hashtable<String, Object> props = new Hashtable<String, Object>();
            ((Dictionary)props).put("scheduler.concurrent", false);
            ((Dictionary)props).put("scheduler.period", cleanupDelay);
            ((Dictionary)props).put("scheduler.threadPool", "content-distribution");
            this.packageCleanup = context.registerService(Runnable.class, (Object)cleanup, props);
            wrapped = resourceDistributionPackageBuilder;
        }
        int monitoringQueueSize = conf.monitoringQueueSize();
        this.packageBuilder = new MonitoringDistributionPackageBuilder(monitoringQueueSize, wrapped, context);
    }

    @Deactivate
    public void deactivate() {
        this.packageBuilder.clear();
        if (this.packageCleanup != null) {
            this.packageCleanup.unregister();
        }
    }

    @Override
    public String getType() {
        return this.packageBuilder.getType();
    }

    @Override
    @NotNull
    public DistributionPackage createPackage(@NotNull ResourceResolver resourceResolver, @NotNull DistributionRequest request) throws DistributionException {
        return this.packageBuilder.createPackage(resourceResolver, request);
    }

    @Override
    @NotNull
    public DistributionPackage readPackage(@NotNull ResourceResolver resourceResolver, @NotNull InputStream stream) throws DistributionException {
        return this.packageBuilder.readPackage(resourceResolver, stream);
    }

    @Override
    @Nullable
    public DistributionPackage getPackage(@NotNull ResourceResolver resourceResolver, @NotNull String id) throws DistributionException {
        return this.packageBuilder.getPackage(resourceResolver, id);
    }

    @Override
    public boolean installPackage(@NotNull ResourceResolver resourceResolver, @NotNull DistributionPackage distributionPackage) throws DistributionException {
        return this.packageBuilder.installPackage(resourceResolver, distributionPackage);
    }

    @Override
    @NotNull
    public DistributionPackageInfo installPackage(@NotNull ResourceResolver resourceResolver, @NotNull InputStream stream) throws DistributionException {
        return this.packageBuilder.installPackage(resourceResolver, stream);
    }

    @ObjectClassDefinition(name="Apache Sling Distribution Packaging - Package Builder Factory", description="OSGi configuration for package builders")
    public static @interface Config {
        @AttributeDefinition(name="name", description="The name of the package builder.")
        public String name();

        @AttributeDefinition(name="type", description="The persistence type used by this package builder", options={@Option(label="resource", value="resource package"), @Option(label="file", value="file package"), @Option(label="inmemory", value="in memory packages")})
        public String type() default "resource";

        @AttributeDefinition(name="Content Serializer", description="The target reference for the DistributionSerializationFormat used to (de)serialize packages, e.g. use target=(name=...) to bind to services by name.")
        public String format_target() default "(name=default)";

        @AttributeDefinition(name="Temp Filesystem Folder", description="The filesystem folder where the temporary files should be saved.")
        public String tempFsFolder();

        @AttributeDefinition(name="File threshold", description="Once the data reaches the configurable size value, buffering to memory switches to file buffering.")
        public int fileThreshold() default 1;

        @AttributeDefinition(name="The memory unit for the file threshold", description="The memory unit for the file threshold, Megabytes by default", options={@Option(label="BYTES", value="Bytes"), @Option(label="KILO_BYTES", value="Kilobytes"), @Option(label="MEGA_BYTES", value="Megabytes"), @Option(label="GIGA_BYTES", value="Gigabytes")})
        public String memoryUnit() default "MEGA_BYTES";

        @AttributeDefinition(name="Flag to enable/disable the off-heap memory", description="Flag to enable/disable the off-heap memory, false by default")
        public boolean useOffHeapMemory() default false;

        @AttributeDefinition(name="The digest algorithm to calculate the package checksum", description="The digest algorithm to calculate the package checksum, Megabytes by default", options={@Option(label="NONE", value="Do not send digest"), @Option(label="MD2", value="md2"), @Option(label="MD5", value="md5"), @Option(label="SHA-1", value="sha1"), @Option(label="SHA-256", value="sha256"), @Option(label="SHA-384", value="sha384"), @Option(label="SHA-512", value="sha512")})
        public String digestAlgorithm() default "NONE";

        @AttributeDefinition(name="The number of items for monitoring distribution packages creation/installation", description="The number of items for monitoring distribution packages creation/installation, 100 by default")
        public int monitoringQueueSize() default 0;

        @AttributeDefinition(name="The delay in seconds between two runs of the cleanup phase for resource persisted packages.", description="The resource persisted packages are cleaned up periodically (asynchronously) since SLING-6503.The delay between two runs of the cleanup phase can be configured with this setting. 60 seconds by default")
        public long cleanupDelay() default 60L;

        @AttributeDefinition(name="Package Node Filters", description="The package node path filters. Filter format: path|+include|-exclude", cardinality=100)
        public String[] package_filters();

        @AttributeDefinition(name="Package Property Filters", description="The package property path filters. Filter format: path|+include|-exclude", cardinality=0x7FFFFFFF)
        public String[] property_filters();
    }
}

