/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.impl.jobs.console;

import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.felix.inventory.Format;
import org.apache.felix.inventory.InventoryPrinter;
import org.apache.sling.discovery.InstanceDescription;
import org.apache.sling.event.impl.jobs.JobConsumerManager;
import org.apache.sling.event.impl.jobs.config.InternalQueueConfiguration;
import org.apache.sling.event.impl.jobs.config.JobManagerConfiguration;
import org.apache.sling.event.impl.jobs.config.TopologyCapabilities;
import org.apache.sling.event.jobs.JobManager;
import org.apache.sling.event.jobs.Queue;
import org.apache.sling.event.jobs.QueueConfiguration;
import org.apache.sling.event.jobs.ScheduleInfo;
import org.apache.sling.event.jobs.ScheduledJobInfo;
import org.apache.sling.event.jobs.Statistics;
import org.apache.sling.event.jobs.TopicStatistics;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={InventoryPrinter.class}, property={"service.vendor=The Apache Software Foundation", "felix.inventory.printer.name=slingjobs", "felix.inventory.printer.title=Sling Jobs", "felix.inventory.printer.format=TEXT", "felix.inventory.printer.format=JSON", "felix.inventory.printer.webconsole:Boolean=false"})
public class InventoryPlugin
implements InventoryPrinter {
    @Reference
    private JobManager jobManager;
    @Reference
    private JobManagerConfiguration configuration;
    @Reference
    private JobConsumerManager jobConsumerManager;
    private final DateFormat dateFormat = new SimpleDateFormat("HH:mm:ss:SSS yyyy-MMM-dd");

    private String formatArrayAsText(String[] array) {
        if (array == null || array.length == 0) {
            return "";
        }
        return Arrays.toString(array);
    }

    private String formatType(QueueConfiguration.Type type) {
        switch (type) {
            case ORDERED: {
                return "Ordered";
            }
            case TOPIC_ROUND_ROBIN: {
                return "Topic Round Robin";
            }
            case UNORDERED: {
                return "Parallel";
            }
        }
        return type.toString();
    }

    private synchronized String formatDate(long time) {
        if (time == -1L) {
            return "-";
        }
        Date d = new Date(time);
        return this.dateFormat.format(d);
    }

    private String formatTime(long time) {
        if (time == 0L) {
            return "-";
        }
        if (time < 1000L) {
            return time + " ms";
        }
        if (time < 60000L) {
            return time / 1000L + " secs";
        }
        long min = time / 1000L / 60L;
        long secs = time - min * 1000L * 60L;
        return min + " min " + secs / 1000L + " secs";
    }

    public void print(PrintWriter pw, Format format, boolean isZip) {
        if (format.equals(Format.TEXT)) {
            this.printText(pw);
        } else if (format.equals(Format.JSON)) {
            this.printJson(pw);
        }
    }

    private void printText(PrintWriter pw) {
        InternalQueueConfiguration[] configs;
        pw.println("Apache Sling Job Handling");
        pw.println("-------------------------");
        String topics = this.jobConsumerManager.getTopics();
        if (topics == null) {
            topics = "";
        }
        Statistics s = this.jobManager.getStatistics();
        pw.println("Overall Statistics");
        pw.printf("Start Time : %s%n", this.formatDate(s.getStartTime()));
        pw.printf("Local topic consumers: %s%n", topics);
        pw.printf("Last Activated : %s%n", this.formatDate(s.getLastActivatedJobTime()));
        pw.printf("Last Finished : %s%n", this.formatDate(s.getLastFinishedJobTime()));
        pw.printf("Queued Jobs : %s%n", s.getNumberOfQueuedJobs());
        pw.printf("Active Jobs : %s%n", s.getNumberOfActiveJobs());
        pw.printf("Jobs : %s%n", s.getNumberOfJobs());
        pw.printf("Finished Jobs : %s%n", s.getNumberOfFinishedJobs());
        pw.printf("Failed Jobs : %s%n", s.getNumberOfFailedJobs());
        pw.printf("Cancelled Jobs : %s%n", s.getNumberOfCancelledJobs());
        pw.printf("Processed Jobs : %s%n", s.getNumberOfProcessedJobs());
        pw.printf("Average Processing Time : %s%n", this.formatTime(s.getAverageProcessingTime()));
        pw.printf("Average Waiting Time : %s%n", this.formatTime(s.getAverageWaitingTime()));
        pw.println();
        pw.println("Topology Capabilities");
        TopologyCapabilities cap = this.configuration.getTopologyCapabilities();
        if (cap == null) {
            pw.print("No topology information available !");
        } else {
            Map<String, List<InstanceDescription>> instanceCaps = cap.getInstanceCapabilities();
            for (Map.Entry<String, List<InstanceDescription>> entry : instanceCaps.entrySet()) {
                StringBuilder sb = new StringBuilder();
                for (InstanceDescription id : entry.getValue()) {
                    if (sb.length() > 0) {
                        sb.append(", ");
                    }
                    if (id.isLocal()) {
                        sb.append("local");
                        continue;
                    }
                    sb.append(id.getSlingId());
                }
                pw.printf("%s : %s%n", entry.getKey(), sb.toString());
            }
        }
        pw.println();
        pw.println("Scheduled Jobs");
        Collection infos = this.jobManager.getScheduledJobs();
        if (infos.size() == 0) {
            pw.print("No jobs currently scheduled");
        } else {
            for (Object info : infos) {
                pw.println("Schedule");
                pw.printf("Job Topic< : %s%n", info.getJobTopic());
                pw.print("Schedules : ");
                boolean first = true;
                block11: for (ScheduleInfo si : info.getSchedules()) {
                    if (!first) {
                        pw.print(", ");
                    }
                    first = false;
                    switch (si.getType()) {
                        case YEARLY: {
                            pw.printf("YEARLY %s %s : %s:%s", si.getMonthOfYear(), si.getDayOfMonth(), si.getHourOfDay(), si.getMinuteOfHour());
                            continue block11;
                        }
                        case MONTHLY: {
                            pw.printf("MONTHLY %s : %s:%s", si.getDayOfMonth(), si.getHourOfDay(), si.getMinuteOfHour());
                            continue block11;
                        }
                        case WEEKLY: {
                            pw.printf("WEEKLY %s : %s:%s", si.getDayOfWeek(), si.getHourOfDay(), si.getMinuteOfHour());
                            continue block11;
                        }
                        case DAILY: {
                            pw.printf("DAILY %s:%s", si.getHourOfDay(), si.getMinuteOfHour());
                            continue block11;
                        }
                        case HOURLY: {
                            pw.printf("HOURLY %s", si.getMinuteOfHour());
                            continue block11;
                        }
                        case CRON: {
                            pw.printf("CRON %s", si.getExpression());
                            continue block11;
                        }
                    }
                    pw.printf("AT %s", si.getAt());
                }
                pw.println();
                pw.println();
            }
        }
        pw.println();
        boolean isEmpty = true;
        for (Queue q : this.jobManager.getQueues()) {
            isEmpty = false;
            pw.printf("Active JobQueue: %s %s%n", q.getName(), q.isSuspended() ? "(SUSPENDED)" : "");
            s = q.getStatistics();
            QueueConfiguration c = q.getConfiguration();
            pw.println("Statistics");
            pw.printf("Start Time : %s%n", this.formatDate(s.getStartTime()));
            pw.printf("Last Activated : %s%n", this.formatDate(s.getLastActivatedJobTime()));
            pw.printf("Last Finished : %s%n", this.formatDate(s.getLastFinishedJobTime()));
            pw.printf("Queued Jobs : %s%n", s.getNumberOfQueuedJobs());
            pw.printf("Active Jobs : %s%n", s.getNumberOfActiveJobs());
            pw.printf("Jobs : %s%n", s.getNumberOfJobs());
            pw.printf("Finished Jobs : %s%n", s.getNumberOfFinishedJobs());
            pw.printf("Failed Jobs : %s%n", s.getNumberOfFailedJobs());
            pw.printf("Cancelled Jobs : %s%n", s.getNumberOfCancelledJobs());
            pw.printf("Processed Jobs : %s%n", s.getNumberOfProcessedJobs());
            pw.printf("Average Processing Time : %s%n", this.formatTime(s.getAverageProcessingTime()));
            pw.printf("Average Waiting Time : %s%n", this.formatTime(s.getAverageWaitingTime()));
            pw.printf("Status Info : %s%n", q.getStateInfo());
            pw.println("Configuration");
            pw.printf("Type : %s%n", this.formatType(c.getType()));
            pw.printf("Topics : %s%n", this.formatArrayAsText(c.getTopics()));
            pw.printf("Max Parallel : %s%n", c.getMaxParallel());
            pw.printf("Max Retries : %s%n", c.getMaxRetries());
            pw.printf("Retry Delay : %s ms%n", c.getRetryDelayInMs());
            pw.printf("Priority : %s%n", c.getThreadPriority());
            pw.println();
        }
        if (isEmpty) {
            pw.println("No active queues.");
            pw.println();
        }
        for (TopicStatistics ts : this.jobManager.getTopicStatistics()) {
            pw.printf("Topic Statistics - %s%n", ts.getTopic());
            pw.printf("Last Activated : %s%n", this.formatDate(ts.getLastActivatedJobTime()));
            pw.printf("Last Finished : %s%n", this.formatDate(ts.getLastFinishedJobTime()));
            pw.printf("Finished Jobs : %s%n", ts.getNumberOfFinishedJobs());
            pw.printf("Failed Jobs : %s%n", ts.getNumberOfFailedJobs());
            pw.printf("Cancelled Jobs : %s%n", ts.getNumberOfCancelledJobs());
            pw.printf("Processed Jobs : %s%n", ts.getNumberOfProcessedJobs());
            pw.printf("Average Processing Time : %s%n", this.formatTime(ts.getAverageProcessingTime()));
            pw.printf("Average Waiting Time : %s%n", this.formatTime(ts.getAverageWaitingTime()));
            pw.println();
        }
        pw.println("Apache Sling Job Handling - Job Queue Configurations");
        pw.println("----------------------------------------------------");
        this.printQueueConfiguration(pw, this.configuration.getQueueConfigurationManager().getMainQueueConfiguration());
        for (InternalQueueConfiguration c : configs = this.configuration.getQueueConfigurationManager().getConfigurations()) {
            this.printQueueConfiguration(pw, c);
        }
    }

    private void printQueueConfiguration(PrintWriter pw, InternalQueueConfiguration c) {
        pw.printf("Job Queue Configuration: %s%n", c.getName());
        pw.printf("Valid : %s%n", c.isValid());
        pw.printf("Type : %s%n", this.formatType(c.getType()));
        pw.printf("Topics : %s%n", this.formatArrayAsText(c.getTopics()));
        pw.printf("Max Parallel : %s%n", c.getMaxParallel());
        pw.printf("Max Retries : %s%n", c.getMaxRetries());
        pw.printf("Retry Delay : %s ms%n", c.getRetryDelayInMs());
        pw.printf("Priority : %s%n", c.getThreadPriority());
        pw.printf("Ranking : %s%n", c.getRanking());
        pw.println();
    }

    private void printJson(PrintWriter pw) {
        InternalQueueConfiguration[] configs;
        pw.println("{");
        Statistics s = this.jobManager.getStatistics();
        pw.println("  \"statistics\" : {");
        pw.printf("    \"startTime\" : %s,%n", s.getStartTime());
        pw.printf("    \"startTimeText\" : \"%s\",%n", this.formatDate(s.getStartTime()));
        pw.printf("    \"lastActivatedJobTime\" : %s,%n", s.getLastActivatedJobTime());
        pw.printf("    \"lastActivatedJobTimeText\" : \"%s\",%n", this.formatDate(s.getLastActivatedJobTime()));
        pw.printf("    \"lastFinishedJobTime\" : %s,%n", s.getLastFinishedJobTime());
        pw.printf("    \"lastFinishedJobTimeText\" : \"%s\",%n", this.formatDate(s.getLastFinishedJobTime()));
        pw.printf("    \"numberOfQueuedJobs\" : %s,%n", s.getNumberOfQueuedJobs());
        pw.printf("    \"numberOfActiveJobs\" : %s,%n", s.getNumberOfActiveJobs());
        pw.printf("    \"numberOfJobs\" : %s,%n", s.getNumberOfJobs());
        pw.printf("    \"numberOfFinishedJobs\" : %s,%n", s.getNumberOfFinishedJobs());
        pw.printf("    \"numberOfFailedJobs\" : %s,%n", s.getNumberOfFailedJobs());
        pw.printf("    \"numberOfCancelledJobs\" : %s,%n", s.getNumberOfCancelledJobs());
        pw.printf("    \"numberOfProcessedJobs\" : %s,%n", s.getNumberOfProcessedJobs());
        pw.printf("    \"averageProcessingTime\" : %s,%n", s.getAverageProcessingTime());
        pw.printf("    \"averageProcessingTimeText\" : \"%s\",%n", this.formatTime(s.getAverageProcessingTime()));
        pw.printf("    \"averageWaitingTime\" : %s,%n", s.getAverageWaitingTime());
        pw.printf("    \"averageWaitingTimeText\" : \"%s\"%n", this.formatTime(s.getAverageWaitingTime()));
        pw.print("  }");
        TopologyCapabilities cap = this.configuration.getTopologyCapabilities();
        if (cap != null) {
            pw.println(",");
            pw.println("  \"capabilities\" : [");
            Map<String, List<InstanceDescription>> instanceCaps = cap.getInstanceCapabilities();
            Iterator<Map.Entry<String, List<InstanceDescription>>> iter = instanceCaps.entrySet().iterator();
            while (iter.hasNext()) {
                Iterator entry = iter.next();
                ArrayList<String> instances = new ArrayList<String>();
                for (InstanceDescription id : (List)entry.getValue()) {
                    if (id.isLocal()) {
                        instances.add("local");
                        continue;
                    }
                    instances.add(id.getSlingId());
                }
                pw.println("    {");
                pw.printf("       \"topic\" : \"%s\",%n", entry.getKey());
                pw.printf("       \"instances\" : %s%n", this.formatArrayAsJson(instances.toArray(new String[instances.size()])));
                if (iter.hasNext()) {
                    pw.println("    },");
                    continue;
                }
                pw.println("    }");
            }
            pw.print("  ]");
        }
        boolean first = true;
        Collection infos = this.jobManager.getScheduledJobs();
        for (ScheduledJobInfo info : infos) {
            pw.println(",");
            if (first) {
                pw.println("  \"scheduledJobs\" : [");
                first = false;
            }
            pw.println("    {");
            pw.printf("      \"jobTopic\" : \"%s\",%n", info.getJobTopic());
            pw.println("      \"schedules\" : [");
            boolean internalFirst = true;
            for (ScheduleInfo si : info.getSchedules()) {
                if (!internalFirst) {
                    pw.println(", ");
                }
                internalFirst = false;
                pw.println("        {");
                switch (si.getType()) {
                    case YEARLY: {
                        pw.printf("          \"type\" : \"%s\",%n", "YEARLY");
                        pw.printf("          \"schedule\" : \"%s %s : %s:%s\"%n", si.getMonthOfYear(), si.getDayOfMonth(), si.getHourOfDay(), si.getMinuteOfHour());
                        break;
                    }
                    case MONTHLY: {
                        pw.printf("          \"type\" : \"%s\",%n", "MONTHLY");
                        pw.printf("          \"schedule\" : \"%s : %s:%s\"%n", si.getDayOfMonth(), si.getHourOfDay(), si.getMinuteOfHour());
                        break;
                    }
                    case WEEKLY: {
                        pw.printf("          \"type\" : \"%s\",%n", "WEEKLY");
                        pw.printf("          \"schedule\" : \"%s : %s:%s\"%n", si.getDayOfWeek(), si.getHourOfDay(), si.getMinuteOfHour());
                        break;
                    }
                    case DAILY: {
                        pw.printf("          \"type\" : \"%s\",%n", "DAILY");
                        pw.printf("          \"schedule\" : \"%s:%s\"%n", si.getHourOfDay(), si.getMinuteOfHour());
                        break;
                    }
                    case HOURLY: {
                        pw.printf("          \"type\" : \"%s\",%n", "HOURLY");
                        pw.printf("          \"schedule\" : \"%s\"%n", si.getMinuteOfHour());
                        break;
                    }
                    case CRON: {
                        pw.printf("          \"type\" : \"%s\",%n", "CRON");
                        pw.printf("          \"schedule\" : \"%s\"%n", si.getExpression());
                        break;
                    }
                    default: {
                        pw.printf("          \"type\" : \"%s\",%n", "AT");
                        pw.printf("          \"schedule\" : \"%s\"%n", si.getAt());
                    }
                }
                pw.print("        }");
            }
            pw.println("      ]");
            pw.println("    }");
        }
        if (!first) {
            pw.print("  ]");
        }
        first = true;
        for (Queue q : this.jobManager.getQueues()) {
            pw.println(",");
            if (first) {
                pw.println("  \"queues\" : [");
                first = false;
            }
            pw.println("    {");
            pw.printf("      \"name\" : \"%s\",%n", q.getName());
            pw.printf("      \"suspended\" : %s,%n", q.isSuspended());
            s = q.getStatistics();
            pw.println("      \"statistics\" : {");
            pw.printf("        \"startTime\" : %s,%n", s.getStartTime());
            pw.printf("        \"startTimeText\" : \"%s\",%n", this.formatDate(s.getStartTime()));
            pw.printf("        \"lastActivatedJobTime\" : %s,%n", s.getLastActivatedJobTime());
            pw.printf("        \"lastActivatedJobTimeText\" : \"%s\",%n", this.formatDate(s.getLastActivatedJobTime()));
            pw.printf("        \"lastFinishedJobTime\" : %s,%n", s.getLastFinishedJobTime());
            pw.printf("        \"lastFinishedJobTimeText\" : \"%s\",%n", this.formatDate(s.getLastFinishedJobTime()));
            pw.printf("        \"numberOfQueuedJobs\" : %s,%n", s.getNumberOfQueuedJobs());
            pw.printf("        \"numberOfActiveJobs\" : %s,%n", s.getNumberOfActiveJobs());
            pw.printf("        \"numberOfJobs\" : %s,%n", s.getNumberOfJobs());
            pw.printf("        \"numberOfFinishedJobs\" : %s,%n", s.getNumberOfFinishedJobs());
            pw.printf("        \"numberOfFailedJobs\" : %s,%n", s.getNumberOfFailedJobs());
            pw.printf("        \"numberOfCancelledJobs\" : %s,%n", s.getNumberOfCancelledJobs());
            pw.printf("        \"numberOfProcessedJobs\" : %s,%n", s.getNumberOfProcessedJobs());
            pw.printf("        \"averageProcessingTime\" : %s,%n", s.getAverageProcessingTime());
            pw.printf("        \"averageProcessingTimeText\" : \"%s\",%n", this.formatTime(s.getAverageProcessingTime()));
            pw.printf("        \"averageWaitingTime\" : %s,%n", s.getAverageWaitingTime());
            pw.printf("        \"averageWaitingTimeText\" : \"%s\"%n", this.formatTime(s.getAverageWaitingTime()));
            pw.print("      },");
            QueueConfiguration c = q.getConfiguration();
            pw.printf("      \"stateInfo\" : \"%s\",%n", q.getStateInfo());
            pw.println("      \"configuration\" : {");
            pw.printf("        \"type\" : \"%s\",%n", c.getType());
            pw.printf("        \"topics\" : %s,%n", this.formatArrayAsJson(c.getTopics()));
            pw.printf("        \"maxParallel\" : %s,%n", c.getMaxParallel());
            pw.printf("        \"maxRetries\" : %s,%n", c.getMaxRetries());
            pw.printf("        \"retryDelayInMs\" : %s,%n", c.getRetryDelayInMs());
            pw.printf("        \"priority\" : \"%s\"%n", c.getThreadPriority());
            pw.println("      }");
            pw.print("    }");
        }
        if (!first) {
            pw.print("  ]");
        }
        first = true;
        for (TopicStatistics ts : this.jobManager.getTopicStatistics()) {
            pw.println(",");
            if (first) {
                pw.println("  \"topicStatistics\" : [");
                first = false;
            }
            pw.println("    {");
            pw.printf("      \"topic\" : \"%s\",%n", ts.getTopic());
            pw.printf("      \"lastActivatedJobTime\" : %s,%n", ts.getLastActivatedJobTime());
            pw.printf("      \"lastActivatedJobTimeText\" : \"%s\",%n", this.formatDate(ts.getLastActivatedJobTime()));
            pw.printf("      \"lastFinishedJobTime\" : %s,%n", ts.getLastFinishedJobTime());
            pw.printf("      \"lastFinishedJobTimeText\" : \"%s\",%n", this.formatDate(ts.getLastFinishedJobTime()));
            pw.printf("      \"numberOfFinishedJobs\" : %s,%n", ts.getNumberOfFinishedJobs());
            pw.printf("      \"numberOfFailedJobs\" : %s,%n", ts.getNumberOfFailedJobs());
            pw.printf("      \"numberOfCancelledJobs\" : %s,%n", ts.getNumberOfCancelledJobs());
            pw.printf("      \"numberOfProcessedJobs\" : %s,%n", ts.getNumberOfProcessedJobs());
            pw.printf("      \"averageProcessingTime\" : %s,%n", ts.getAverageProcessingTime());
            pw.printf("      \"averageProcessingTimeText\" : \"%s\",%n", this.formatTime(ts.getAverageProcessingTime()));
            pw.printf("      \"averageWaitingTime\" : %s,%n", ts.getAverageWaitingTime());
            pw.printf("      \"averageWaitingTimeText\" : \"%s\"%n", this.formatTime(ts.getAverageWaitingTime()));
            pw.print("    }");
        }
        if (!first) {
            pw.print("  ]");
        }
        pw.println(",");
        pw.println("  \"configurations\" : [");
        this.printQueueConfigurationJson(pw, this.configuration.getQueueConfigurationManager().getMainQueueConfiguration());
        for (InternalQueueConfiguration c : configs = this.configuration.getQueueConfigurationManager().getConfigurations()) {
            pw.println(",");
            this.printQueueConfigurationJson(pw, c);
        }
        pw.println();
        pw.println("  ]");
        pw.println("}");
    }

    private void printQueueConfigurationJson(PrintWriter pw, InternalQueueConfiguration c) {
        pw.println("    {");
        pw.printf("      \"name\" : \"%s\",%n", c.getName());
        pw.printf("      \"valid\" : %s,%n", c.isValid());
        pw.printf("      \"type\" : \"%s\",%n", c.getType());
        pw.printf("      \"topics\" : %s,%n", this.formatArrayAsJson(c.getTopics()));
        pw.printf("      \"maxParallel\" : %s,%n", c.getMaxParallel());
        pw.printf("      \"maxRetries\" : %s,%n", c.getMaxRetries());
        pw.printf("      \"retryDelayInMs\" : %s,%n", c.getRetryDelayInMs());
        pw.printf("      \"priority\" : \"%s\",%n", c.getThreadPriority());
        pw.printf("      \"ranking\" : %s%n", c.getRanking());
        pw.print("    }");
    }

    private String formatArrayAsJson(String[] array) {
        if (array == null || array.length == 0) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder("[");
        boolean first = true;
        for (String s : array) {
            if (!first) {
                sb.append(", ");
            }
            first = false;
            sb.append("\"");
            sb.append(s);
            sb.append("\"");
        }
        sb.append("]");
        return sb.toString();
    }
}

