/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.util;

import java.util.Comparator;
import javax.jcr.Item;
import javax.jcr.RepositoryException;
import javax.xml.namespace.QName;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.NameFactory;
import org.apache.jackrabbit.spi.commons.conversion.NameException;
import org.apache.jackrabbit.spi.commons.conversion.NameParser;
import org.apache.jackrabbit.spi.commons.name.NameFactoryImpl;
import org.apache.jackrabbit.spi.commons.namespace.NamespaceResolver;
import org.apache.jackrabbit.vault.util.QNameComparator;

public class ItemNameComparator2
implements Comparator<Item> {
    private final NamespaceResolver nsResolver;

    public ItemNameComparator2(NamespaceResolver nsResolver) {
        this.nsResolver = nsResolver;
    }

    private QName getQName(String rawName) throws RepositoryException {
        try {
            Name name = NameParser.parse((String)rawName, (NamespaceResolver)this.nsResolver, (NameFactory)NameFactoryImpl.getInstance());
            return new QName(name.getNamespaceURI(), name.getLocalName(), this.nsResolver.getPrefix(name.getNamespaceURI()));
        }
        catch (NameException e) {
            String msg = "internal error: failed to resolve namespace mappings";
            throw new RepositoryException(msg, (Throwable)e);
        }
    }

    @Override
    public int compare(Item o1, Item o2) {
        try {
            return QNameComparator.INSTANCE.compare(this.getQName(o1.getName()), this.getQName(o2.getName()));
        }
        catch (RepositoryException e) {
            throw new IllegalStateException(e);
        }
    }
}

