/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.cpconverter.accesscontrol;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Mapping {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String serviceName;
    private final String subServiceName;
    private final String userName;
    private final Set<String> principalNames;

    public Mapping(@NotNull String spec) {
        this(spec, false);
    }

    public Mapping(@NotNull String spec, boolean enforceMappingByPrincipal) {
        int colon = spec.indexOf(58);
        int equals = spec.indexOf(61);
        if (colon == 0 || equals <= 0) {
            throw new IllegalArgumentException("serviceName is required");
        }
        if (equals == spec.length() - 1) {
            throw new IllegalArgumentException("userName or principalNames is required");
        }
        if (colon + 1 == equals) {
            throw new IllegalArgumentException("serviceInfo must not be empty");
        }
        if (colon < 0 || colon > equals) {
            this.serviceName = spec.substring(0, equals);
            this.subServiceName = null;
        } else {
            this.serviceName = spec.substring(0, colon);
            this.subServiceName = spec.substring(colon + 1, equals);
        }
        String s = spec.substring(equals + 1);
        if (s.charAt(0) == '[' && s.charAt(s.length() - 1) == ']') {
            this.userName = null;
            this.principalNames = Mapping.extractPrincipalNames(s);
        } else if (enforceMappingByPrincipal) {
            this.userName = null;
            this.principalNames = Collections.singleton(s);
            this.logger.info("Enforcing service mapping by principal name for '{}'", (Object)spec);
        } else {
            this.userName = s;
            this.principalNames = null;
        }
    }

    @NotNull
    private static Set<String> extractPrincipalNames(@NotNull String s) {
        String[] sArr = s.substring(1, s.length() - 1).split(",");
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (String name : sArr) {
            String n = name.trim();
            if (n.isEmpty()) continue;
            set.add(n);
        }
        return set;
    }

    public boolean mapsUser(@NotNull String userId) {
        return userId.equals(this.userName);
    }

    public boolean mapsPrincipal(@NotNull String principalName) {
        return this.principalNames != null && this.principalNames.contains(principalName);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Objects.hash(this.serviceName);
        result = 31 * result + Objects.hash(this.subServiceName);
        result = 31 * result + Objects.hash(this.userName);
        result = 31 * result + Objects.hash(this.principalNames);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Mapping other = (Mapping)obj;
        return Objects.equals(this.serviceName, other.serviceName) && Objects.equals(this.subServiceName, other.subServiceName) && Objects.equals(this.userName, other.userName) && Objects.equals(this.principalNames, other.principalNames);
    }

    public String toString() {
        String name = this.userName != null ? "userName=" + this.userName : "principleNames" + this.principalNames.toString();
        return "Mapping [serviceName=" + this.serviceName + ", subServiceName=" + this.subServiceName + ", " + name;
    }

    @NotNull
    public String asString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.serviceName);
        if (this.subServiceName != null) {
            sb.append(':').append(this.subServiceName);
        }
        sb.append('=');
        if (this.userName != null) {
            sb.append(this.userName);
        } else {
            sb.append('[');
            Iterator<String> it = this.principalNames.iterator();
            while (it.hasNext()) {
                sb.append(it.next());
                if (!it.hasNext()) continue;
                sb.append(',');
            }
            sb.append(']');
        }
        return sb.toString();
    }
}

