/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.cpconverter.repoinit;

import java.util.Formatter;
import java.util.List;
import org.apache.sling.feature.cpconverter.ConverterException;
import org.apache.sling.feature.cpconverter.accesscontrol.EnforceInfo;
import org.apache.sling.feature.cpconverter.repoinit.AccessControlVisitor;
import org.apache.sling.feature.cpconverter.repoinit.ConversionMap;
import org.apache.sling.feature.cpconverter.repoinit.DefaultVisitor;
import org.apache.sling.feature.cpconverter.repoinit.OperatorConverterException;
import org.apache.sling.feature.cpconverter.repoinit.SystemUserVisitor;
import org.apache.sling.repoinit.parser.operations.Operation;
import org.apache.sling.repoinit.parser.operations.OperationVisitor;
import org.jetbrains.annotations.NotNull;

public class OperationProcessor {
    public void apply(@NotNull List<Operation> ops, @NotNull Formatter formatter, @NotNull EnforceInfo enforceInfo) throws ConverterException {
        try {
            ConversionMap toConvert = new ConversionMap();
            OperationVisitor[] visitors = new OperationVisitor[]{new DefaultVisitor(formatter), new SystemUserVisitor(formatter, enforceInfo), new AccessControlVisitor(formatter, enforceInfo, toConvert)};
            for (Operation op : ops) {
                for (OperationVisitor v : visitors) {
                    op.accept(v);
                }
            }
            toConvert.generateRepoInit(formatter);
        }
        catch (OperatorConverterException oce) {
            throw oce.getConverterException();
        }
    }
}

