/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.validation.spi.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import org.apache.jackrabbit.vault.fs.api.PathFilterSet;
import org.apache.jackrabbit.vault.packaging.Dependency;
import org.apache.jackrabbit.vault.packaging.PackageInfo;
import org.apache.jackrabbit.vault.packaging.PackageProperties;
import org.apache.jackrabbit.vault.validation.spi.PropertiesValidator;
import org.apache.jackrabbit.vault.validation.spi.ValidationMessage;
import org.apache.jackrabbit.vault.validation.spi.ValidationMessageSeverity;
import org.jetbrains.annotations.NotNull;

public final class DependencyValidator
implements PropertiesValidator {
    static final String MESSAGE_DEPENDENCIES_WITH_OVERLAPPING_FILTERS = "Dependency '%s' defines same filter root '%s' as dependency '%s'";
    static final String MESSAGE_UNRESOLVED_DEPENDENCY = "Dependency '%s' was not successfully resolved and can therefore not be used for analysis.";
    private final Collection<PackageInfo> dependenciesMetaInfo;
    private final ValidationMessageSeverity severity;
    private final ValidationMessageSeverity severityForUnresolvedDependencies;

    public DependencyValidator(@NotNull ValidationMessageSeverity severity, ValidationMessageSeverity severityForUnresolvedDependencies, Collection<PackageInfo> dependenciesMetaInfo) {
        this.dependenciesMetaInfo = dependenciesMetaInfo;
        this.severity = severity;
        this.severityForUnresolvedDependencies = severityForUnresolvedDependencies;
    }

    @Override
    public Collection<ValidationMessage> done() {
        return null;
    }

    @Override
    public Collection<ValidationMessage> validate(@NotNull PackageProperties properties) {
        LinkedList<ValidationMessage> messages = new LinkedList<ValidationMessage>();
        HashMap<String, PackageInfo> roots = new HashMap<String, PackageInfo>();
        for (Dependency dependency : properties.getDependencies()) {
            boolean isDependencyResolved = false;
            for (PackageInfo resolvedDependency : this.dependenciesMetaInfo) {
                if (!dependency.matches(resolvedDependency.getId())) continue;
                for (PathFilterSet set : resolvedDependency.getFilter().getFilterSets()) {
                    String root = set.getRoot();
                    PackageInfo existing = (PackageInfo)roots.get(root);
                    if (existing != null) {
                        String msg = String.format(MESSAGE_DEPENDENCIES_WITH_OVERLAPPING_FILTERS, resolvedDependency.getId(), root, existing.getId());
                        messages.add(new ValidationMessage(this.severity, msg));
                    }
                    roots.put(root, resolvedDependency);
                }
                isDependencyResolved = true;
                break;
            }
            if (isDependencyResolved) continue;
            String msg = String.format(MESSAGE_UNRESOLVED_DEPENDENCY, dependency);
            messages.add(new ValidationMessage(this.severityForUnresolvedDependencies, msg));
        }
        return messages;
    }
}

