/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.base.internal;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Pattern;
import org.apache.sling.jcr.base.internal.AllowListFragment;
import org.apache.sling.jcr.base.internal.LoginAdminAllowListConfiguration;
import org.osgi.framework.Bundle;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.util.converter.Converters;
import org.osgi.util.converter.Converting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={LoginAdminAllowList.class}, configurationPid={"org.apache.sling.jcr.base.LoginAdminAllowList", "org.apache.sling.jcr.base.internal.LoginAdminWhitelist"})
public class LoginAdminAllowList {
    public static final String PID = "org.apache.sling.jcr.base.LoginAdminAllowList";
    public static final String LEGACY_PID = "org.apache.sling.jcr.base.internal.LoginAdminWhitelist";
    static final Logger LOG = LoggerFactory.getLogger(LoginAdminAllowList.class);
    private static final String LEGACY_BYPASS_PROPERTY = "whitelist.bypass";
    private static final String LEGACY_BUNDLES_PROPERTY = "whitelist.bundles.regexp";
    private static final String PROP_LEGACY_BUNDLES_DEFAULT = "whitelist.bundles.default";
    private static final String PROP_LEGACY_BUNDLES_ADDITIONAL = "whitelist.bundles.additional";
    private volatile ConfigurationState config;
    private final List<AllowListFragment> allowListFragments = new CopyOnWriteArrayList<AllowListFragment>();
    private final Map<String, AllowListFragment> backwardsCompatibleFragments = new ConcurrentHashMap<String, AllowListFragment>();

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    void bindAllowListFragment(AllowListFragment fragment) {
        this.allowListFragments.add(fragment);
        LOG.info("AllowListFragment added '{}'", (Object)fragment);
    }

    void unbindAllowListFragment(AllowListFragment fragment) {
        this.allowListFragments.remove(fragment);
        LOG.info("AllowListFragment removed '{}'", (Object)fragment);
    }

    @Activate
    @Modified
    void configure(LoginAdminAllowListConfiguration configuration, Map<String, Object> properties) {
        this.config = new ConfigurationState(configuration, properties);
        this.ensureBackwardsCompatibility(properties, PROP_LEGACY_BUNDLES_DEFAULT);
        this.ensureBackwardsCompatibility(properties, PROP_LEGACY_BUNDLES_ADDITIONAL);
    }

    public boolean allowLoginAdministrative(Bundle b) {
        ConfigurationState localConfig = this.config;
        if (localConfig == null) {
            throw new IllegalStateException("LoginAdminAllowList has no configuration.");
        }
        if (localConfig.bypassAllowList) {
            LOG.debug("Allow list is bypassed, all bundles allowed to use loginAdministrative");
            return true;
        }
        String bsn = b.getSymbolicName();
        if (localConfig.allowListRegexp != null && localConfig.allowListRegexp.matcher(bsn).matches()) {
            LOG.debug("{} is allow listed to use loginAdministrative, by regexp", (Object)bsn);
            return true;
        }
        for (AllowListFragment fragment : this.allowListFragments) {
            if (!fragment.allows(bsn)) continue;
            LOG.debug("{} is allow listed to use loginAdministrative, by allow list fragment '{}'", (Object)bsn, (Object)fragment);
            return true;
        }
        LOG.debug("{} is not allow listed to use loginAdministrative", (Object)bsn);
        return false;
    }

    private void ensureBackwardsCompatibility(Map<String, Object> properties, String propertyName) {
        AllowListFragment oldFragment = this.backwardsCompatibleFragments.remove(propertyName);
        String[] bsns = (String[])Converters.standardConverter().convert(properties.get(propertyName)).to(String[].class);
        if (bsns != null && bsns.length != 0) {
            LOG.warn("Using deprecated configuration property '{}'", (Object)propertyName);
            AllowListFragment fragment = new AllowListFragment("deprecated-" + propertyName, bsns);
            this.bindAllowListFragment(fragment);
            this.backwardsCompatibleFragments.put(propertyName, fragment);
        }
        if (oldFragment != null) {
            this.unbindAllowListFragment(oldFragment);
        }
    }

    static class ConfigurationState {
        public final boolean bypassAllowList;
        public final Pattern allowListRegexp;

        ConfigurationState(LoginAdminAllowListConfiguration config, Map<String, Object> properties) {
            String regexp;
            boolean bypass = config.allowlist_bypass();
            Object legacyBypassObject = properties.get(LoginAdminAllowList.LEGACY_BYPASS_PROPERTY);
            if (legacyBypassObject != null) {
                LOG.warn("Using deprecated configuration property '{}' from configuration '{}'. Update your configuration to use configuration '{}' and property '{}' instead.", new Object[]{LoginAdminAllowList.LEGACY_BYPASS_PROPERTY, LoginAdminAllowList.LEGACY_PID, LoginAdminAllowList.PID, "allowlist.bypass"});
                bypass = (Boolean)((Converting)Converters.standardConverter().convert(legacyBypassObject).defaultValue((Object)false)).to(Boolean.class);
            }
            String legacyRegexp = null;
            Object legacyBundlesObject = properties.get(LoginAdminAllowList.LEGACY_BUNDLES_PROPERTY);
            if (legacyBypassObject != null) {
                LOG.warn("Using deprecated configuration property '{}' from configuration '{}'. Update your configuration to use configuration '{}' and property '{}' instead.", new Object[]{LoginAdminAllowList.LEGACY_BUNDLES_PROPERTY, LoginAdminAllowList.LEGACY_PID, LoginAdminAllowList.PID, "allowlist.bundles.regexp"});
                legacyRegexp = (String)Converters.standardConverter().convert(legacyBundlesObject).to(String.class);
            }
            if ((regexp = config.allowlist_bundles_regexp()).trim().length() > 0) {
                if (legacyRegexp != null) {
                    LOG.warn("Both deprecated configuration property '{}' and non-deprecated configuration property '{}' are set. The deprecated property '{}' is ignored.", new Object[]{LoginAdminAllowList.LEGACY_BUNDLES_PROPERTY, "allowlist.bundles.regexp", LoginAdminAllowList.LEGACY_BUNDLES_PROPERTY});
                }
                this.allowListRegexp = Pattern.compile(regexp);
            } else {
                Pattern pattern = this.allowListRegexp = legacyRegexp != null ? Pattern.compile(legacyRegexp) : null;
            }
            if (this.allowListRegexp != null) {
                LOG.warn("A 'allowlist.bundles.regexp' is configured, this is NOT RECOMMENDED for production: {}", (Object)this.allowListRegexp);
            }
            this.bypassAllowList = bypass;
            if (this.bypassAllowList) {
                LOG.info("allowlist.bypass=true, allowed BSNs=<ALL>");
                LOG.warn("All bundles are allowed to use loginAdministrative due to the 'allowlist.bypass' configuration of this service. This is NOT RECOMMENDED, for security reasons.");
            }
        }
    }
}

