/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.junit.scriptable;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import javax.jcr.query.Query;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.engine.SlingRequestProcessor;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.junit.TestsProvider;
import org.apache.sling.junit.scriptable.ExplainTests;
import org.apache.sling.junit.scriptable.TestAllPaths;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={TestsProvider.class})
public class ScriptableTestsProvider
implements TestsProvider {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private String pid;
    private Session session;
    private ResourceResolver resolver;
    private long lastModified = System.currentTimeMillis();
    private long lastReloaded;
    private static List<String> testPaths = new LinkedList<String>();
    public static final String SLING_TEST_NODETYPE = "sling:Test";
    public static final String TEST_CLASS_NAME = ScriptableTestsProvider.class.getName();
    static final ThreadLocal<TestContext> testContext = new ThreadLocal();
    private String[] allowedRoots;
    @Reference
    private SlingRepository repository;
    @Reference
    private SlingRequestProcessor requestProcessor;
    @Reference
    private ResourceResolverFactory resolverFactory;
    private List<EventListener> listeners = new ArrayList<EventListener>();

    protected void activate(Map<String, Object> props) throws Exception {
        this.pid = (String)props.get("service.pid");
        this.session = this.repository.loginAdministrative(this.repository.getDefaultWorkspace());
        HashMap<String, Session> auth = new HashMap<String, Session>();
        auth.put("user.jcr.session", this.session);
        this.resolver = this.resolverFactory.getResourceResolver(auth);
        String[] paths = this.resolver.getSearchPath();
        this.allowedRoots = new String[paths.length];
        System.arraycopy(paths, 0, this.allowedRoots, 0, paths.length);
        for (int i = 0; i < this.allowedRoots.length; ++i) {
            if (this.allowedRoots[i].endsWith("/")) continue;
            int n = i;
            this.allowedRoots[n] = this.allowedRoots[n] + "/";
        }
        int eventTypes = 31;
        boolean isDeep = true;
        boolean noLocal = true;
        String[] nodeTypes = new String[]{SLING_TEST_NODETYPE};
        String[] uuid = null;
        for (String path : this.allowedRoots) {
            RootListener listener = new RootListener(path);
            this.listeners.add(listener);
            this.session.getWorkspace().getObservationManager().addEventListener((EventListener)listener, 31, path, true, uuid, nodeTypes, true);
            this.log.debug("Listening for JCR events under {}", (Object)path);
        }
        this.log.info("Activated, will look for test resources under {}", Arrays.asList(this.allowedRoots));
    }

    protected void deactivate() throws RepositoryException {
        if (this.resolver != null) {
            this.resolver.close();
            this.resolver = null;
        }
        if (this.session != null) {
            for (EventListener listener : this.listeners) {
                this.session.getWorkspace().getObservationManager().removeEventListener(listener);
            }
            this.listeners.clear();
            this.session.logout();
        }
        this.session = null;
    }

    public Class<?> createTestClass(String testName) throws ClassNotFoundException {
        if (!testName.equals(TEST_CLASS_NAME)) {
            throw new ClassNotFoundException(testName + " - the only valid name is " + TEST_CLASS_NAME);
        }
        try {
            this.maybeQueryTestResources();
        }
        catch (Exception e) {
            throw new RuntimeException("Exception in maybeQueryTestResources()", e);
        }
        if (testPaths.size() == 0) {
            return ExplainTests.class;
        }
        testContext.set(new TestContext(testPaths, this.requestProcessor, this.resolver));
        return TestAllPaths.class;
    }

    public String getServicePid() {
        return this.pid;
    }

    public List<String> getTestNames() {
        LinkedList<String> result = new LinkedList<String>();
        result.add(TEST_CLASS_NAME);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> maybeQueryTestResources() throws RepositoryException {
        if (this.lastModified <= this.lastReloaded) {
            this.log.debug("No changes detected, keeping existing list of {} test resources", (Object)testPaths.size());
            return testPaths;
        }
        this.log.info("Changes detected, reloading list of test resources");
        long reloadTime = System.currentTimeMillis();
        LinkedList<String> newList = new LinkedList<String>();
        for (String root : this.allowedRoots) {
            String statement = "/jcr:root" + root + "/element(*, " + SLING_TEST_NODETYPE + ")";
            this.log.debug("Querying for test nodes: {}", (Object)statement);
            this.session.refresh(true);
            Query q = this.session.getWorkspace().getQueryManager().createQuery(statement, "xpath");
            NodeIterator it = q.execute().getNodes();
            while (it.hasNext()) {
                String path = it.nextNode().getPath();
                newList.add(path);
                this.log.debug("Test resource found: {}", (Object)path);
            }
        }
        this.log.info("List of test resources updated, {} resource(s) found under {}", (Object)newList.size(), Arrays.asList(this.allowedRoots));
        List<String> list = testPaths;
        synchronized (list) {
            testPaths.clear();
            testPaths.addAll(newList);
        }
        this.lastReloaded = reloadTime;
        return testPaths;
    }

    public long lastModified() {
        return this.lastModified;
    }

    static TestContext getTestContext() {
        return testContext.get();
    }

    class RootListener
    implements EventListener {
        private final String path;

        RootListener(String path) {
            this.path = path;
        }

        public void onEvent(EventIterator it) {
            ScriptableTestsProvider.this.log.debug("Change detected under {}, will reload list of test paths", (Object)this.path);
            ScriptableTestsProvider.this.lastModified = System.currentTimeMillis();
        }
    }

    static class TestContext {
        final List<String> testPaths;
        final SlingRequestProcessor requestProcessor;
        final ResourceResolver resourceResolver;

        TestContext(List<String> p, SlingRequestProcessor rp, ResourceResolver rr) {
            this.testPaths = p;
            this.requestProcessor = rp;
            this.resourceResolver = rr;
        }
    }
}

