/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.launchpad.startupmanager;

import java.lang.management.ManagementFactory;
import java.util.Hashtable;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.sling.launchpad.api.LaunchpadContentProvider;
import org.apache.sling.launchpad.api.StartupHandler;
import org.apache.sling.launchpad.api.StartupListener;
import org.apache.sling.launchpad.startupmanager.LaunchpadContentProviderImpl;
import org.apache.sling.launchpad.startupmanager.MBeanStartupListener;
import org.apache.sling.launchpad.startupmanager.StartUpHandlerImpl;
import org.apache.sling.launchpad.startupmanager.StartupListenerTracker;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator {
    private static final Logger log = LoggerFactory.getLogger(Activator.class);
    private StartupListenerTracker startupListenerTracker;

    public void start(BundleContext bundleContext) {
        this.startupListenerTracker = new StartupListenerTracker(bundleContext);
        this.registerMBeanServer(bundleContext);
        try {
            this.registerMBeanStartupListener(bundleContext);
        }
        catch (MalformedObjectNameException e) {
            log.error("Can't instantiate MBeanStartupListener");
        }
        this.registerStartupHandler(bundleContext);
        this.registerLaunchpadContentProvider(bundleContext);
    }

    public void stop(BundleContext context) {
        if (this.startupListenerTracker != null) {
            this.startupListenerTracker.close();
            this.startupListenerTracker = null;
        }
    }

    private ServiceRegistration<MBeanServer> registerMBeanServer(BundleContext bundleContext) {
        MBeanServer platformMBeanServer = ManagementFactory.getPlatformMBeanServer();
        Hashtable<String, String> mbeanProps = new Hashtable<String, String>();
        try {
            ObjectName beanName = ObjectName.getInstance("JMImplementation:type=MBeanServerDelegate");
            AttributeList attrs = platformMBeanServer.getAttributes(beanName, new String[]{"MBeanServerId", "SpecificationName", "SpecificationVersion", "SpecificationVendor", "ImplementationName", "ImplementationVersion", "ImplementationVendor"});
            for (Object object : attrs) {
                Attribute attr = (Attribute)object;
                if (attr.getValue() == null) continue;
                mbeanProps.put(attr.getName(), attr.getValue().toString());
            }
        }
        catch (Exception je) {
            log.error("start: Cannot set service properties of Platform MBeanServer service, registering without", (Throwable)je);
        }
        return bundleContext.registerService(MBeanServer.class, (Object)platformMBeanServer, mbeanProps);
    }

    private ServiceRegistration<StartupHandler> registerStartupHandler(BundleContext bundleContext) {
        return bundleContext.registerService(StartupHandler.class, (Object)new StartUpHandlerImpl(bundleContext.getBundle(0L)), null);
    }

    private ServiceRegistration<LaunchpadContentProvider> registerLaunchpadContentProvider(BundleContext bundleContext) {
        return bundleContext.registerService(LaunchpadContentProvider.class, (Object)new LaunchpadContentProviderImpl(bundleContext.getBundle(0L)), null);
    }

    private ServiceRegistration<StartupListener> registerMBeanStartupListener(BundleContext bundleContext) throws MalformedObjectNameException {
        return bundleContext.registerService(StartupListener.class, (Object)new MBeanStartupListener(), null);
    }
}

