/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.launchpad.startupmanager;

import java.util.Hashtable;
import org.apache.sling.launchpad.api.StartupListener;
import org.apache.sling.launchpad.api.StartupMode;
import org.apache.sling.launchpad.api.StartupService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.startlevel.StartLevel;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartupListenerTracker
implements FrameworkListener,
BundleListener {
    private static final Logger log = LoggerFactory.getLogger(StartupListenerTracker.class);
    private static final int TARGET_START_LEVEL = 30;
    private final StartupMode startupMode;
    private final BundleContext bundleContext;
    private final ServiceTracker<StartupListener, StartupListener> tracker;
    private final ServiceReference<StartLevel> startLevelServiceReference;
    private final StartLevel startLevelService;
    private volatile boolean frameworkStarted;
    private boolean startLevelBased;

    StartupListenerTracker(final BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.startupMode = StartupMode.INSTALL;
        this.startLevelBased = Boolean.valueOf(bundleContext.getProperty("sling.launchpad.startlevel.based"));
        this.startLevelServiceReference = bundleContext.getServiceReference(StartLevel.class);
        this.startLevelService = this.startLevelServiceReference != null ? (StartLevel)bundleContext.getService(this.startLevelServiceReference) : null;
        this.tracker = new ServiceTracker(bundleContext, StartupListener.class, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<StartupListener, StartupListener>(){

            public void removedService(ServiceReference<StartupListener> reference, StartupListener service) {
                bundleContext.ungetService(reference);
            }

            public void modifiedService(ServiceReference<StartupListener> reference, StartupListener service) {
            }

            public StartupListener addingService(ServiceReference<StartupListener> reference) {
                StartupListener listener = (StartupListener)bundleContext.getService(reference);
                if (listener != null) {
                    try {
                        listener.inform(StartupListenerTracker.this.startupMode, StartupListenerTracker.this.frameworkStarted);
                    }
                    catch (Throwable t) {
                        log.error("Error calling StartupListener {}", (Object)listener, (Object)t);
                    }
                }
                return listener;
            }
        });
        this.tracker.open();
        bundleContext.addFrameworkListener((FrameworkListener)this);
        bundleContext.addBundleListener((BundleListener)this);
    }

    public void close() {
        this.bundleContext.removeFrameworkListener((FrameworkListener)this);
        this.bundleContext.removeBundleListener((BundleListener)this);
        this.tracker.close();
        if (this.startLevelServiceReference != null) {
            this.bundleContext.ungetService(this.startLevelServiceReference);
        }
    }

    public void frameworkEvent(FrameworkEvent event) {
        if (event.getType() == 8 && this.startLevelService != null) {
            int startLevel = this.startLevelService.getStartLevel();
            if (startLevel >= 30) {
                this.onFinished();
            }
        } else if (event.getType() == 1 && !this.startLevelBased) {
            this.onFinished();
        }
    }

    public void bundleChanged(BundleEvent event) {
        if (event.getType() == 2 && !this.frameworkStarted) {
            Bundle[] allBundles = this.bundleContext.getBundles();
            int total = allBundles.length;
            int started = 0;
            for (Bundle b : allBundles) {
                if (b.getState() != 32) continue;
                ++started;
            }
            float ratio = 0.0f;
            if (total > 0) {
                ratio = (float)started / (float)total;
            }
            log.info("Startup progress: {}% (bundles {}/{})", new Object[]{(int)(ratio * 100.0f), started, total});
            for (StartupListener listener : (StartupListener[])this.tracker.getServices((Object[])new StartupListener[0])) {
                listener.startupProgress(ratio);
            }
        }
    }

    private void onFinished() {
        this.frameworkStarted = true;
        log.info("Startup finished");
        for (StartupListener listener : (StartupListener[])this.tracker.getServices((Object[])new StartupListener[0])) {
            listener.startupFinished(this.startupMode);
        }
        StartupService startupService = new StartupService(){

            public StartupMode getStartupMode() {
                return StartupListenerTracker.this.startupMode;
            }
        };
        this.bundleContext.registerService(StartupService.class, (Object)startupService, new Hashtable());
    }
}

