/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.sling.resourcemerger.spi;

import java.util.List;

import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.jetbrains.annotations.NotNull;
import org.osgi.annotation.versioning.ConsumerType;

/**
 * Service interface which can be implemented to define an algorithm used to pick
 * resources to be merged. For each picker service, a separate {@link org.apache.sling.spi.resource.provider.ResourceProvider}
 * will be exposed at the MERGE_ROOT of the picker.
 * @deprecated Use new {@link MergedResourcePicker2} instead.
 */
@Deprecated
@ConsumerType
public interface MergedResourcePicker {

    /**
     * Service property name identifying the root path for the merged resources.
     * By convention, starts, with /mnt, although this is by no means required.
     * The value of this service property must be of type String and must not end
     * in a slash.
     */
    String MERGE_ROOT = MergedResourcePicker2.MERGE_ROOT;

    /**
     * Service property name specifying whether the resources are read-only
     * or support CRUD operations. If not specified this property defaults
     * to <code>true</code>. The value of this property must be of type
     * Boolean.
     */
    String READ_ONLY = MergedResourcePicker2.READ_ONLY;

    /**
     * Service property name specifying whether the parent hierarchy is
     * traversed to check for hiding properties. If not specified this
     * property defaults to <code>false</code>. The value of this
     * property must be of type Boolean.
     */
    String TRAVERSE_PARENT = MergedResourcePicker2.TRAVERSE_PARENT;

    /**
     * Method invoked by the MergingResourceProvider to identify the resources to be merged for a given
     * relative path. The resources returned may be either resources returned from the ResourceResolver
     * directory or an instance of NonExistingResource.
     * 
     * @param resolver the ResourceResolver
     * @param relativePath the path relative to the merge root
     * @return a List of Resource objects
     * @see MergedResourcePicker2#pickResources(ResourceResolver, String, Resource)
     */
    @NotNull List<@NotNull Resource> pickResources(@NotNull ResourceResolver resolver, @NotNull String relativePath);
}
