/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.sample.slingshot.comments.impl;

import java.io.IOException;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.sample.slingshot.comments.Comment;
import org.apache.sling.sample.slingshot.comments.CommentsService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class}, property={"sling.servlet.methods=POST", "sling.servlet.extensions=comments", "sling.servlet.resourceTypes=slingshot/Streamentry"})
public class CommentPostServlet
extends SlingAllMethodsServlet {
    private static final long serialVersionUID = 1L;
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Reference
    private ResourceResolverFactory factory;
    @Reference
    private CommentsService commentsService;

    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        String title = request.getParameter("title");
        String text = request.getParameter("text");
        String userId = request.getRemoteUser();
        this.logger.debug("New comment from {} : {} - {}", new Object[]{userId, title, text});
        try (ResourceResolver resolver = null;){
            resolver = this.factory.getServiceResourceResolver(null);
            Resource reqResource = resolver.getResource(request.getResource().getPath());
            Comment c = new Comment();
            c.setTitle(title);
            c.setText(text);
            c.setCreatedBy(userId);
            this.commentsService.addComment(reqResource, c);
            String path = request.getResource().getPath();
            response.sendRedirect(resolver.map(request.getContextPath() + path + ".html"));
        }
    }
}

