/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.freemarker.internal;

import freemarker.template.Configuration;
import freemarker.template.TemplateModel;
import freemarker.template.Version;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.commons.osgi.SortingServiceTracker;
import org.apache.sling.scripting.api.AbstractScriptEngineFactory;
import org.apache.sling.scripting.freemarker.internal.FreemarkerScriptEngine;
import org.apache.sling.scripting.freemarker.internal.FreemarkerScriptEngineFactoryConfiguration;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.metatype.annotations.Designate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={ScriptEngineFactory.class}, immediate=true, property={"service.description=Apache Sling Scripting FreeMarker ScriptEngineFactory", "service.vendor=The Apache Software Foundation"})
@Designate(ocd=FreemarkerScriptEngineFactoryConfiguration.class)
public class FreemarkerScriptEngineFactory
extends AbstractScriptEngineFactory {
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    private volatile Configuration configuration;
    private BundleContext bundleContext;
    private SortingServiceTracker<TemplateModel> templateModelTracker;
    private final Configuration defaultConfiguration;
    private static final String FREEMARKER_NAME = "FreeMarker";
    private final Logger logger = LoggerFactory.getLogger(FreemarkerScriptEngineFactory.class);

    public FreemarkerScriptEngineFactory() {
        String version = Configuration.getVersion().toString();
        Version incompatibleImprovements = new Version(version);
        this.defaultConfiguration = new Configuration(incompatibleImprovements);
        this.defaultConfiguration.setDefaultEncoding(StandardCharsets.UTF_8.name());
    }

    @Activate
    private void activate(FreemarkerScriptEngineFactoryConfiguration configuration, BundleContext bundleContext) {
        this.logger.debug("activate");
        this.configure(configuration);
        this.bundleContext = bundleContext;
        this.templateModelTracker = new SortingServiceTracker(bundleContext, TemplateModel.class.getName());
        this.templateModelTracker.open();
    }

    @Modified
    private void modified(FreemarkerScriptEngineFactoryConfiguration configuration) {
        this.logger.debug("modified");
        this.configure(configuration);
    }

    @Deactivate
    private void deactivate() {
        this.logger.debug("deactivate");
        this.templateModelTracker.close();
        this.templateModelTracker = null;
        this.bundleContext = null;
    }

    private void configure(FreemarkerScriptEngineFactoryConfiguration configuration) {
        this.setExtensions(configuration.extensions());
        this.setMimeTypes(configuration.mimeTypes());
        this.setNames(configuration.names());
    }

    public ScriptEngine getScriptEngine() {
        return new FreemarkerScriptEngine(this);
    }

    public String getLanguageName() {
        return FREEMARKER_NAME;
    }

    public String getLanguageVersion() {
        return Configuration.getVersion().toString();
    }

    Configuration getConfiguration() {
        Configuration configuration = this.configuration;
        if (configuration != null) {
            return configuration;
        }
        return this.defaultConfiguration;
    }

    Map<String, Map<String, TemplateModel>> getTemplateModels() {
        HashMap<String, Map<String, TemplateModel>> models = new HashMap<String, Map<String, TemplateModel>>();
        for (ServiceReference serviceReference : this.templateModelTracker.getSortedServiceReferences()) {
            String namespace = (String)serviceReference.getProperty("namespace");
            String name = (String)serviceReference.getProperty("name");
            if (!StringUtils.isNotBlank((CharSequence)namespace) || !StringUtils.isNotBlank((CharSequence)name)) continue;
            if (!models.containsKey(namespace)) {
                models.put(namespace, new HashMap());
            }
            ((Map)models.get(namespace)).put(name, this.bundleContext.getService(serviceReference));
        }
        return models;
    }
}

