/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.html.dom.template;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import org.apache.sling.scripting.sightly.impl.html.dom.AttributeList;
import org.apache.sling.scripting.sightly.impl.html.dom.DocumentHandler;
import org.apache.sling.scripting.sightly.impl.html.dom.HtmlParser;
import org.apache.sling.scripting.sightly.impl.html.dom.template.Template;
import org.apache.sling.scripting.sightly.impl.html.dom.template.TemplateAttribute;
import org.apache.sling.scripting.sightly.impl.html.dom.template.TemplateCommentNode;
import org.apache.sling.scripting.sightly.impl.html.dom.template.TemplateElementNode;
import org.apache.sling.scripting.sightly.impl.html.dom.template.TemplateTextNode;

public class TemplateParser {
    public Template parse(Reader reader) throws IOException {
        TemplateParserContext context = new TemplateParserContext();
        HtmlParser.parse(reader, context);
        return context.getTemplate();
    }

    public static final class TemplateParserContext
    implements DocumentHandler {
        private StringBuilder textBuilder = new StringBuilder();
        private final Deque<TemplateElementNode> elementStack = new ArrayDeque<TemplateElementNode>();
        private Template template;

        public Template getTemplate() {
            return this.template;
        }

        @Override
        public void onStart() throws IOException {
            this.template = new Template();
            this.elementStack.push(this.template);
        }

        @Override
        public void onEnd() throws IOException {
            this.checkText();
            this.elementStack.clear();
        }

        private void checkText() {
            if (this.textBuilder.length() > 0) {
                this.elementStack.peek().addChild(new TemplateTextNode(this.textBuilder.toString()));
                this.textBuilder = new StringBuilder();
            }
        }

        @Override
        public void onStartElement(String name, AttributeList attList, boolean endSlash) {
            this.checkText();
            ArrayList<TemplateAttribute> attrs = new ArrayList<TemplateAttribute>();
            Iterator<String> iter = attList.attributeNames();
            while (iter.hasNext()) {
                String aName = iter.next();
                TemplateAttribute attr = new TemplateAttribute(aName, attList.getValue(aName), attList.getQuoteChar(aName));
                attrs.add(attr);
            }
            TemplateElementNode element = new TemplateElementNode(name, endSlash, attrs);
            element.setHasStartElement();
            this.elementStack.peek().addChild(element);
            if (!endSlash) {
                this.elementStack.push(element);
            }
        }

        @Override
        public void onEndElement(String name) {
            this.checkText();
            if (this.contains(name)) {
                TemplateElementNode element = this.elementStack.pop();
                while (!name.equals(element.getName())) {
                    element = this.elementStack.pop();
                }
                element.setHasEndElement();
            } else {
                TemplateElementNode element = new TemplateElementNode(name, false, new ArrayList<TemplateAttribute>());
                this.elementStack.peek().addChild(element);
                element.setHasEndElement();
            }
        }

        @Override
        public void onCharacters(char[] ch, int off, int len) {
            this.textBuilder.append(ch, off, len);
        }

        @Override
        public void onComment(String text) throws IOException {
            this.checkText();
            this.elementStack.peek().addChild(new TemplateCommentNode(text));
        }

        private boolean contains(String name) {
            for (TemplateElementNode elem : this.elementStack) {
                if (!name.equals(elem.getName())) continue;
                return true;
            }
            return false;
        }
    }
}

