/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.sitemap.impl.builder;

import java.io.Closeable;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import javax.xml.stream.XMLOutputFactory;
import org.apache.sling.sitemap.SitemapException;
import org.apache.sling.sitemap.builder.Sitemap;
import org.apache.sling.sitemap.builder.Url;
import org.apache.sling.sitemap.impl.builder.UrlImpl;
import org.apache.sling.sitemap.impl.builder.extensions.ExtensionProviderManager;
import org.jetbrains.annotations.NotNull;

public class SitemapImpl
implements Sitemap,
Closeable {
    static final String SITEMAP_NAMESPACE = "http://www.sitemaps.org/schemas/sitemap/0.9";
    protected final Writer out;
    private final ExtensionProviderManager extensionProviderManager;
    private final XMLOutputFactory xmlWriterFactory;
    private boolean closed = false;
    private UrlImpl pendingUrl;

    public SitemapImpl(Writer writer, ExtensionProviderManager extensionProviderManager) throws IOException {
        this(writer, extensionProviderManager, true);
    }

    public SitemapImpl(Writer writer, ExtensionProviderManager extensionProviderManager, boolean writeHeader) throws IOException {
        this.extensionProviderManager = extensionProviderManager;
        this.xmlWriterFactory = XMLOutputFactory.newFactory();
        this.out = writer;
        if (writeHeader) {
            this.out.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            this.out.write("<urlset xmlns=\"http://www.sitemaps.org/schemas/sitemap/0.9\"");
            for (Map.Entry<String, String> entry : extensionProviderManager.getNamespaces().entrySet()) {
                this.out.write(32);
                this.out.write("xmlns:");
                this.out.write(entry.getValue());
                this.out.write("=\"");
                this.out.write(entry.getKey());
                this.out.write(34);
            }
            this.out.write(62);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        try {
            this.closed = true;
            this.writePendingUrl();
            this.out.write("</urlset>");
            this.out.flush();
        }
        catch (SitemapException ex) {
            SitemapImpl.unwrapIOException(ex);
        }
    }

    public void flush() throws IOException {
        try {
            this.ensureNotClosed();
            this.writePendingUrl();
            this.out.flush();
        }
        catch (SitemapException ex) {
            SitemapImpl.unwrapIOException(ex);
        }
    }

    @Override
    @NotNull
    public Url addUrl(@NotNull String location) throws SitemapException {
        this.ensureNotClosed();
        this.writePendingUrl();
        this.pendingUrl = new UrlImpl(location, this.out, this.xmlWriterFactory, this.extensionProviderManager);
        return this.pendingUrl;
    }

    protected boolean writePendingUrl() throws SitemapException {
        if (this.pendingUrl != null) {
            this.pendingUrl.write();
            this.pendingUrl = null;
            return true;
        }
        return false;
    }

    private void ensureNotClosed() {
        if (this.closed) {
            throw new IllegalStateException("Sitemap already closed");
        }
    }

    private static void unwrapIOException(Exception ex) throws IOException {
        if (ex.getCause() instanceof IOException) {
            throw (IOException)ex.getCause();
        }
        throw new IOException(ex);
    }
}

