/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.sitemap.impl.console;

import java.io.PrintWriter;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.apache.felix.inventory.Format;
import org.apache.felix.inventory.InventoryPrinter;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.sitemap.SitemapInfo;
import org.apache.sling.sitemap.SitemapService;
import org.apache.sling.sitemap.SitemapUtil;
import org.apache.sling.sitemap.impl.SitemapServiceConfiguration;
import org.jetbrains.annotations.Nullable;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={InventoryPrinter.class}, property={"felix.inventory.printer.name=slingsitemap", "felix.inventory.printer.title=Sling Sitemap", "felix.inventory.printer.format=JSON", "felix.inventory.printer.format=TEXT", "felix.inventory.printer.webconsole=true"})
public class SitemapInventoryPlugin
implements InventoryPrinter {
    private static final Map<String, Object> AUTH = Collections.singletonMap("sling.service.subservice", "sitemap-reader");
    private static final Logger LOG = LoggerFactory.getLogger(SitemapInventoryPlugin.class);
    @Reference
    private SitemapService sitemapService;
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    @Reference
    private SitemapServiceConfiguration configuration;
    private BundleContext bundleContext;

    @Activate
    protected void activate(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void print(PrintWriter printWriter, Format format, boolean isZip) {
        if (Format.JSON.equals(format)) {
            this.printJson(printWriter);
        } else if (Format.TEXT.equals(format)) {
            this.printText(printWriter);
        }
    }

    private void printJson(PrintWriter pw) {
        pw.print('{');
        this.printSchedulerJson(pw);
        pw.print(',');
        this.printRootsJson(pw);
        pw.print('}');
    }

    private void printSchedulerJson(PrintWriter pw) {
        pw.print("\"schedulers\":[");
        boolean hasScheduler = false;
        for (ServiceReference ref : this.bundleContext.getBundle().getRegisteredServices()) {
            Object schedulerExp = ref.getProperty("scheduler.expression");
            Object schedulerName = ref.getProperty("scheduler.name");
            if (!(schedulerExp instanceof String) || !(schedulerName instanceof String)) continue;
            if (hasScheduler) {
                pw.print(',');
            }
            hasScheduler = true;
            pw.print("{\"name\":\"");
            pw.print(SitemapInventoryPlugin.escapeDoubleQuotes((String)schedulerName));
            pw.print("\",\"expression\":\"");
            pw.print(SitemapInventoryPlugin.escapeDoubleQuotes((String)schedulerExp));
            pw.print("\"}");
        }
        pw.print(']');
    }

    private void printRootsJson(PrintWriter pw) {
        pw.print("\"roots\":{");
        try (ResourceResolver resolver = this.resourceResolverFactory.getServiceResourceResolver(AUTH);){
            Iterator<Resource> roots = SitemapUtil.findSitemapRoots(resolver, "/");
            while (roots.hasNext()) {
                Resource root = roots.next();
                pw.print('\"');
                pw.print(SitemapInventoryPlugin.escapeDoubleQuotes(root.getPath()));
                pw.print("\":[");
                Iterator<SitemapInfo> infoIt = this.sitemapService.getSitemapInfo(root).iterator();
                while (infoIt.hasNext()) {
                    SitemapInfo info = infoIt.next();
                    pw.print('{');
                    pw.print("\"name\":\"");
                    pw.print(SitemapInventoryPlugin.escapeDoubleQuotes(info.getName()));
                    pw.print('\"');
                    pw.print(",\"url\":\"");
                    pw.print(SitemapInventoryPlugin.escapeDoubleQuotes(info.getUrl()));
                    pw.print("\",\"status\":\"");
                    pw.print((Object)info.getStatus());
                    pw.print('\"');
                    if (info.getStoragePath() != null) {
                        pw.print(",\"path\":\"");
                        pw.print(SitemapInventoryPlugin.escapeDoubleQuotes(info.getStoragePath()));
                        pw.print("\",\"size\":");
                        pw.print(info.getSize());
                        pw.print(",\"urls\":");
                        pw.print(info.getEntries());
                        pw.print(",\"inLimits\":");
                        pw.print(this.isWithinLimits(info));
                    }
                    pw.print('}');
                    if (!infoIt.hasNext()) continue;
                    pw.print(',');
                }
                pw.print(']');
                if (!roots.hasNext()) continue;
                pw.print(',');
            }
        }
        catch (LoginException ex) {
            pw.println("Failed to list sitemaps: " + ex.getMessage());
            LOG.warn("Failed to get inventory of sitemaps: {}", (Object)ex.getMessage(), (Object)ex);
        }
        pw.print('}');
    }

    private void printText(PrintWriter pw) {
        pw.println("# Apache Sling Sitemap Schedulers");
        pw.println("# -------------------------------");
        this.printSchedulersText(pw);
        pw.println();
        pw.println("# Apache Sling Sitemap Roots");
        pw.println("# --------------------------");
        this.printRootsText(pw);
    }

    private void printSchedulersText(PrintWriter pw) {
        pw.println("schedulers:");
        for (ServiceReference ref : this.bundleContext.getBundle().getRegisteredServices()) {
            Object schedulerExp = ref.getProperty("scheduler.expression");
            Object schedulerName = ref.getProperty("scheduler.name");
            if (schedulerExp == null || schedulerName == null) continue;
            pw.print(" - Name: ");
            pw.print(schedulerName);
            pw.println();
            pw.print("   Expression: ");
            pw.print(schedulerExp);
            pw.println();
        }
    }

    private void printRootsText(PrintWriter pw) {
        pw.println("roots:");
        try (ResourceResolver resolver = this.resourceResolverFactory.getServiceResourceResolver(AUTH);){
            Iterator<Resource> roots = SitemapUtil.findSitemapRoots(resolver, "/");
            while (roots.hasNext()) {
                Resource root = roots.next();
                pw.print("  ");
                pw.print(root.getPath());
                pw.print(':');
                pw.println();
                for (SitemapInfo info : this.sitemapService.getSitemapInfo(root)) {
                    pw.print("   - Name: ");
                    pw.print(info.getName());
                    pw.println();
                    pw.print("     Url: ");
                    pw.print(info.getUrl());
                    pw.println();
                    pw.print("     Status: ");
                    pw.print((Object)info.getStatus());
                    pw.println();
                    if (info.getStoragePath() == null) continue;
                    pw.print("     Path: ");
                    pw.print(info.getStoragePath());
                    pw.println();
                    pw.print("     Size: ");
                    pw.print(info.getSize());
                    pw.println();
                    pw.print("     Urls: ");
                    pw.print(info.getEntries());
                    pw.println();
                    pw.print("     Within Limits: ");
                    pw.print(this.isWithinLimits(info) ? "yes" : "no");
                    pw.println();
                }
            }
        }
        catch (LoginException ex) {
            pw.println("Failed to list sitemaps: " + ex.getMessage());
            LOG.warn("Failed to get inventory of sitemaps: {}", (Object)ex.getMessage(), (Object)ex);
        }
    }

    private boolean isWithinLimits(SitemapInfo info) {
        return info.getSize() <= this.configuration.getMaxSize() && info.getEntries() <= this.configuration.getMaxEntries();
    }

    private static String escapeDoubleQuotes(@Nullable String text) {
        return text == null ? "" : text.replace("\"", "\\\"");
    }
}

