/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.clients.interceptors;

import java.io.IOException;
import java.util.List;
import java.util.ListIterator;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.protocol.HttpContext;
import org.apache.sling.testing.clients.interceptors.StickyCookieHolder;

public class StickyCookieInterceptor
implements HttpRequestInterceptor {
    public void process(HttpRequest httpRequest, HttpContext httpContext) throws HttpException, IOException {
        HttpClientContext clientContext = HttpClientContext.adapt((HttpContext)httpContext);
        List cookies = clientContext.getCookieStore().getCookies();
        boolean set = null != StickyCookieHolder.getTestStickySessionCookie();
        boolean found = false;
        ListIterator<Cookie> it = cookies.listIterator();
        while (it.hasNext()) {
            Cookie cookie = (Cookie)it.next();
            if (!cookie.getName().equals(StickyCookieHolder.COOKIE_NAME)) continue;
            found = true;
            if (set) {
                it.set(StickyCookieHolder.getTestStickySessionCookie());
                continue;
            }
            it.remove();
        }
        if (!found && set) {
            cookies.add(StickyCookieHolder.getTestStickySessionCookie());
        }
        BasicCookieStore cs = new BasicCookieStore();
        cs.addCookies(cookies.toArray(new Cookie[cookies.size()]));
        httpContext.setAttribute("http.cookie-store", (Object)cs);
    }
}

