/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.commons;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sling-mock-oak.com.google.common.base.Objects;

public final class PropertiesUtil {
    private static Logger log = LoggerFactory.getLogger(PropertiesUtil.class);

    private PropertiesUtil() {
    }

    public static boolean toBoolean(Object propValue, boolean defaultValue) {
        if ((propValue = PropertiesUtil.toObject(propValue)) instanceof Boolean) {
            return (Boolean)propValue;
        }
        if (propValue != null) {
            return Boolean.parseBoolean(String.valueOf(propValue));
        }
        return defaultValue;
    }

    public static String toString(Object propValue, String defaultValue) {
        return (propValue = PropertiesUtil.toObject(propValue)) != null ? propValue.toString() : defaultValue;
    }

    public static long toLong(Object propValue, long defaultValue) {
        if ((propValue = PropertiesUtil.toObject(propValue)) instanceof Long) {
            return (Long)propValue;
        }
        if (propValue != null) {
            try {
                return Long.parseLong(String.valueOf(propValue));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static int toInteger(Object propValue, int defaultValue) {
        if ((propValue = PropertiesUtil.toObject(propValue)) instanceof Integer) {
            return (Integer)propValue;
        }
        if (propValue != null) {
            try {
                return Integer.parseInt(String.valueOf(propValue));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static double toDouble(Object propValue, double defaultValue) {
        if ((propValue = PropertiesUtil.toObject(propValue)) instanceof Double) {
            return (Double)propValue;
        }
        if (propValue != null) {
            try {
                return Double.parseDouble(String.valueOf(propValue));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static Object toObject(Object propValue) {
        if (propValue == null) {
            return null;
        }
        if (propValue.getClass().isArray()) {
            Object[] prop = (Object[])propValue;
            return prop.length > 0 ? prop[0] : null;
        }
        if (propValue instanceof Collection) {
            Collection prop = (Collection)propValue;
            return prop.isEmpty() ? null : prop.iterator().next();
        }
        return propValue;
    }

    public static String[] toStringArray(Object propValue) {
        return PropertiesUtil.toStringArray(propValue, null);
    }

    public static String[] toStringArray(Object propValue, String[] defaultArray) {
        if (propValue == null) {
            return defaultArray;
        }
        if (propValue instanceof String) {
            return new String[]{(String)propValue};
        }
        if (propValue instanceof String[]) {
            return (String[])propValue;
        }
        if (propValue.getClass().isArray()) {
            Object[] valueArray = (Object[])propValue;
            ArrayList<String> values = new ArrayList<String>(valueArray.length);
            for (Object value : valueArray) {
                if (value == null) continue;
                values.add(value.toString());
            }
            return values.toArray(new String[values.size()]);
        }
        if (propValue instanceof Collection) {
            Collection valueCollection = (Collection)propValue;
            ArrayList<String> valueList = new ArrayList<String>(valueCollection.size());
            for (Object value : valueCollection) {
                if (value == null) continue;
                valueList.add(value.toString());
            }
            return valueList.toArray(new String[valueList.size()]);
        }
        return defaultArray;
    }

    public static void populate(Object instance, Map<String, ?> config, boolean validate) {
        Class<?> objectClass = instance.getClass();
        Map<String, Method> setters = PropertiesUtil.getSetters(objectClass);
        Objects.ToStringHelper toStringHelper = Objects.toStringHelper(instance);
        for (Map.Entry<String, ?> e : config.entrySet()) {
            String name = e.getKey();
            Method setter = setters.get(name);
            if (setter != null) {
                if (setter.getAnnotation(Deprecated.class) != null) {
                    log.warn("Parameter {} of {} has been deprecated", (Object)name, (Object)objectClass.getName());
                }
                Object value = e.getValue();
                PropertiesUtil.setProperty(instance, name, setter, value);
                toStringHelper.add(name, value);
                continue;
            }
            if (!validate) continue;
            throw new IllegalArgumentException("Configured class " + objectClass.getName() + " does not contain a property named " + name);
        }
        log.debug("Configured object with properties {}", (Object)toStringHelper);
    }

    private static Map<String, Method> getSetters(Class<?> klass) {
        HashMap<String, Method> methods = new HashMap<String, Method>();
        for (Method method : klass.getMethods()) {
            String name = method.getName();
            if (!name.startsWith("set") || name.length() <= 3 || !Modifier.isPublic(method.getModifiers()) || Modifier.isStatic(method.getModifiers()) || !Void.TYPE.equals(method.getReturnType()) || method.getParameterTypes().length != 1) continue;
            methods.put(name.substring(3, 4).toLowerCase(Locale.ENGLISH) + name.substring(4), method);
        }
        return methods;
    }

    private static void setProperty(Object instance, String name, Method setter, Object value) {
        block10: {
            String className = instance.getClass().getName();
            Class<Object> type = setter.getParameterTypes()[0];
            try {
                if (type.isAssignableFrom(String.class) || type.isAssignableFrom(Object.class)) {
                    setter.invoke(instance, value);
                    break block10;
                }
                if (type.isAssignableFrom(Boolean.TYPE) || type.isAssignableFrom(Boolean.class)) {
                    setter.invoke(instance, PropertiesUtil.toBoolean(value, false));
                    break block10;
                }
                if (type.isAssignableFrom(Integer.TYPE) || type.isAssignableFrom(Integer.class)) {
                    setter.invoke(instance, PropertiesUtil.toInteger(value, 0));
                    break block10;
                }
                if (type.isAssignableFrom(Long.TYPE) || type.isAssignableFrom(Long.class)) {
                    setter.invoke(instance, PropertiesUtil.toLong(value, 0L));
                    break block10;
                }
                if (type.isAssignableFrom(Double.TYPE) || type.isAssignableFrom(Double.class)) {
                    setter.invoke(instance, PropertiesUtil.toDouble(value, 0.0));
                    break block10;
                }
                throw new RuntimeException("The type (" + type.getName() + ") of property " + name + " of class " + className + " is not supported");
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("Invalid number format (" + value + ") for property " + name + " of class " + className, e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException("Property " + name + " of class " + className + " can not be set to \"" + value + '\"', e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("The setter of property " + name + " of class " + className + " can not be accessed", e);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException("Unable to call the setter of property " + name + " of class " + className, e);
            }
        }
    }
}

