/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.commons.json;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.jackrabbit.oak.commons.json.JsopBuilder;
import org.apache.jackrabbit.oak.commons.json.JsopTokenizer;

public class JsonObject {
    private Map<String, String> props;
    private Map<String, JsonObject> children;

    public JsonObject() {
        this(false);
    }

    public JsonObject(boolean respectOrder) {
        this.props = JsonObject.map(respectOrder);
        this.children = JsonObject.map(respectOrder);
    }

    private static <K, V> Map<K, V> map(boolean respectOrder) {
        return respectOrder ? new LinkedHashMap() : new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JsonObject fromJson(String json, boolean respectOrder) {
        JsopTokenizer tokenizer = new JsopTokenizer(json);
        tokenizer.read(123);
        try {
            JsonObject jsonObject = JsonObject.create(tokenizer, respectOrder);
            return jsonObject;
        }
        finally {
            tokenizer.read(0);
        }
    }

    public static JsonObject create(JsopTokenizer t, boolean respectOrder) {
        JsonObject obj = new JsonObject(respectOrder);
        if (!t.matches(125)) {
            do {
                String key = t.readString();
                t.read(58);
                if (t.matches(123)) {
                    obj.children.put(key, JsonObject.create(t, respectOrder));
                    continue;
                }
                obj.props.put(key, t.readRawValue().trim());
            } while (t.matches(44));
            t.read(125);
        }
        return obj;
    }

    public static JsonObject create(JsopTokenizer t) {
        return JsonObject.create(t, false);
    }

    public void toJson(JsopBuilder buf) {
        JsonObject.toJson(buf, this);
    }

    public Map<String, String> getProperties() {
        return this.props;
    }

    public Map<String, JsonObject> getChildren() {
        return this.children;
    }

    public String toString() {
        JsopBuilder w = new JsopBuilder();
        this.toJson(w);
        return JsopBuilder.prettyPrint(w.toString());
    }

    private static void toJson(JsopBuilder buf, JsonObject obj) {
        buf.object();
        for (String name : obj.props.keySet()) {
            buf.key(name).encodedValue(obj.props.get(name));
        }
        for (String name : obj.children.keySet()) {
            buf.key(name);
            JsonObject.toJson(buf, obj.children.get(name));
        }
        buf.endObject();
    }
}

