/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authorization.restriction;

import java.util.Collections;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.security.AccessControlException;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.Restriction;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionDefinition;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionPattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface RestrictionProvider {
    public static final RestrictionProvider EMPTY = new RestrictionProvider(){

        @Override
        @NotNull
        public Set<RestrictionDefinition> getSupportedRestrictions(@Nullable String oakPath) {
            return Collections.emptySet();
        }

        @Override
        @NotNull
        public Restriction createRestriction(@Nullable String oakPath, @NotNull String oakName, @NotNull Value value) throws AccessControlException, RepositoryException {
            throw new AccessControlException("This implementation doesn't support any restrictions");
        }

        @Override
        @NotNull
        public Restriction createRestriction(@Nullable String oakPath, @NotNull String oakName, Value ... values) throws AccessControlException, RepositoryException {
            throw new AccessControlException("This implementation doesn't support any restrictions");
        }

        @Override
        @NotNull
        public Set<Restriction> readRestrictions(@Nullable String oakPath, @NotNull Tree aceTree) {
            return Collections.emptySet();
        }

        @Override
        public void writeRestrictions(String oakPath, Tree aceTree, Set<Restriction> restrictions) {
        }

        @Override
        public void validateRestrictions(@Nullable String oakPath, @NotNull Tree aceTree) {
        }

        @Override
        @NotNull
        public RestrictionPattern getPattern(@Nullable String oakPath, @NotNull Tree tree) {
            return RestrictionPattern.EMPTY;
        }

        @Override
        @NotNull
        public RestrictionPattern getPattern(@Nullable String oakPath, @NotNull Set<Restriction> restrictions) {
            return RestrictionPattern.EMPTY;
        }
    };

    @NotNull
    public Set<RestrictionDefinition> getSupportedRestrictions(@Nullable String var1);

    @NotNull
    public Restriction createRestriction(@Nullable String var1, @NotNull String var2, @NotNull Value var3) throws AccessControlException, RepositoryException;

    @NotNull
    public Restriction createRestriction(@Nullable String var1, @NotNull String var2, Value ... var3) throws AccessControlException, RepositoryException;

    @NotNull
    public Set<Restriction> readRestrictions(@Nullable String var1, @NotNull Tree var2);

    public void writeRestrictions(String var1, Tree var2, Set<Restriction> var3) throws RepositoryException;

    public void validateRestrictions(@Nullable String var1, @NotNull Tree var2) throws AccessControlException, RepositoryException;

    @NotNull
    public RestrictionPattern getPattern(@Nullable String var1, @NotNull Tree var2);

    @NotNull
    public RestrictionPattern getPattern(@Nullable String var1, @NotNull Set<Restriction> var2);
}

