/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.thumbnails.internal.transformers;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.coobird.thumbnailator.Thumbnails;
import net.coobird.thumbnailator.geometry.Position;
import net.coobird.thumbnailator.geometry.Positions;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.thumbnails.BadRequestException;
import org.apache.sling.thumbnails.TransformationHandlerConfig;
import org.apache.sling.thumbnails.extension.TransformationHandler;
import org.osgi.service.component.annotations.Component;

@Component(service={TransformationHandler.class}, immediate=true)
public class CropHandler
implements TransformationHandler {
    public static final String PN_POSITION = "position";
    public static final String RESOURCE_TYPE = "sling/thumbnails/transformers/crop";

    @Override
    public String getResourceType() {
        return RESOURCE_TYPE;
    }

    @Override
    public void handle(InputStream inputStream, OutputStream outputStream, TransformationHandlerConfig config) throws IOException {
        Thumbnails.Builder builder = Thumbnails.of((InputStream[])new InputStream[]{inputStream});
        ValueMap properties = config.getProperties();
        CropHandler.resize((Thumbnails.Builder<? extends InputStream>)builder, properties);
        String positionStr = ((String)properties.get(PN_POSITION, (Object)"CENTER")).toUpperCase();
        try {
            Positions pos = Positions.valueOf((String)positionStr);
            builder.crop((Position)pos);
            builder.toOutputStream(outputStream);
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException("Unable to crop due to invalid configuration: \n%s", config.getProperties(), e);
        }
    }

    private static void resize(Thumbnails.Builder<? extends InputStream> builder, ValueMap properties) {
        int width = (Integer)properties.get("width", (Object)-1);
        int height = (Integer)properties.get("height", (Object)-1);
        if (width < 0 || height < 0) {
            throw new BadRequestException("Unable to resize thumbnail due to invalid parameters: \n%s", properties);
        }
        builder.size(width, height);
    }
}

