/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.validation.impl.model;

import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.annotation.Nonnull;
import org.apache.sling.validation.model.ChildResource;
import org.apache.sling.validation.model.ResourceProperty;

public class ChildResourceImpl
implements ChildResource {
    @Nonnull
    private final String name;
    private final Pattern namePattern;
    @Nonnull
    private final List<ResourceProperty> properties;
    @Nonnull
    private final List<ChildResource> children;
    private final boolean isRequired;

    public ChildResourceImpl(@Nonnull String name, String nameRegex, boolean isRequired, @Nonnull List<ResourceProperty> properties, @Nonnull List<ChildResource> children) {
        if (nameRegex != null) {
            try {
                this.namePattern = Pattern.compile(nameRegex);
            }
            catch (PatternSyntaxException e) {
                throw new IllegalArgumentException("Invalid regex given", e);
            }
        } else {
            this.namePattern = null;
        }
        this.name = name;
        this.isRequired = isRequired;
        this.properties = properties;
        this.children = children;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public Collection<ResourceProperty> getProperties() {
        return this.properties;
    }

    public Pattern getNamePattern() {
        return this.namePattern;
    }

    @Nonnull
    public Collection<ChildResource> getChildren() {
        return this.children;
    }

    public boolean isRequired() {
        return this.isRequired;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.children == null ? 0 : this.children.hashCode());
        result = 31 * result + (this.isRequired ? 1231 : 1237);
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.namePattern == null ? 0 : this.namePattern.hashCode());
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ChildResourceImpl other = (ChildResourceImpl)obj;
        if (!this.children.equals(other.children)) {
            return false;
        }
        if (this.isRequired != other.isRequired) {
            return false;
        }
        if (!this.name.equals(other.name)) {
            return false;
        }
        if (this.namePattern == null ? other.namePattern != null : !this.namePattern.pattern().equals(other.namePattern.pattern())) {
            return false;
        }
        return this.properties.equals(other.properties);
    }

    public String toString() {
        return "ChildResourceImpl [name=" + this.name + ", namePattern=" + this.namePattern + ", properties=" + this.properties + ", children=" + this.children + ", isRequired=" + this.isRequired + "]";
    }
}

