/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.shaded.clients.consumer.internals;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.shaded.common.Cluster;
import org.apache.kafka.shaded.common.TopicPartition;

public interface PartitionAssignor {
    public Subscription subscription(Set<String> var1);

    public Map<String, Assignment> assign(Cluster var1, Map<String, Subscription> var2);

    public void onAssignment(Assignment var1);

    public String name();

    public static class Assignment {
        private final List<TopicPartition> partitions;
        private final ByteBuffer userData;

        public Assignment(List<TopicPartition> partitions, ByteBuffer userData) {
            this.partitions = partitions;
            this.userData = userData;
        }

        public Assignment(List<TopicPartition> partitions) {
            this(partitions, ByteBuffer.wrap(new byte[0]));
        }

        public List<TopicPartition> partitions() {
            return this.partitions;
        }

        public ByteBuffer userData() {
            return this.userData;
        }

        public String toString() {
            return "Assignment(partitions=" + this.partitions + ')';
        }
    }

    public static class Subscription {
        private final List<String> topics;
        private final ByteBuffer userData;

        public Subscription(List<String> topics, ByteBuffer userData) {
            this.topics = topics;
            this.userData = userData;
        }

        public Subscription(List<String> topics) {
            this(topics, ByteBuffer.wrap(new byte[0]));
        }

        public List<String> topics() {
            return this.topics;
        }

        public ByteBuffer userData() {
            return this.userData;
        }

        public String toString() {
            return "Subscription(topics=" + this.topics + ')';
        }
    }
}

