/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.client;

import java.io.IOException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.Subject;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginException;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.ClientCnxn;
import org.apache.zookeeper.Login;
import org.apache.zookeeper.SaslClientCallbackHandler;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.proto.GetSASLRequest;
import org.apache.zookeeper.proto.SetSASLResponse;
import org.apache.zookeeper.util.SecurityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperSaslClient {
    public static final String LOGIN_CONTEXT_NAME_KEY = "zookeeper.sasl.clientconfig";
    public static final String ENABLE_CLIENT_SASL_KEY = "zookeeper.sasl.client";
    public static final String ENABLE_CLIENT_SASL_DEFAULT = "true";
    private static volatile boolean initializedLogin = false;
    private static final Logger LOG = LoggerFactory.getLogger(ZooKeeperSaslClient.class);
    private static Login login = null;
    private SaslClient saslClient;
    private boolean isSASLConfigured = true;
    private byte[] saslToken = new byte[0];
    private SaslState saslState = SaslState.INITIAL;
    private boolean gotLastPacket = false;
    private final String configStatus;

    public static boolean isEnabled() {
        return Boolean.valueOf(System.getProperty(ENABLE_CLIENT_SASL_KEY, ENABLE_CLIENT_SASL_DEFAULT));
    }

    public SaslState getSaslState() {
        return this.saslState;
    }

    public String getLoginContext() {
        if (login != null) {
            return login.getLoginContextName();
        }
        return null;
    }

    public ZooKeeperSaslClient(String serverPrincipal) throws LoginException {
        String clientSection = System.getProperty(LOGIN_CONTEXT_NAME_KEY, "Client");
        AppConfigurationEntry[] entries = null;
        RuntimeException runtimeException = null;
        try {
            entries = Configuration.getConfiguration().getAppConfigurationEntry(clientSection);
        }
        catch (SecurityException e) {
            runtimeException = e;
        }
        catch (IllegalArgumentException e) {
            runtimeException = e;
        }
        if (entries != null) {
            this.configStatus = "Will attempt to SASL-authenticate using Login Context section '" + clientSection + "'";
            this.saslClient = this.createSaslClient(serverPrincipal, clientSection);
        } else {
            this.saslState = SaslState.FAILED;
            String explicitClientSection = System.getProperty(LOGIN_CONTEXT_NAME_KEY);
            if (explicitClientSection != null) {
                if (runtimeException != null) {
                    throw new LoginException("Zookeeper client cannot authenticate using the " + explicitClientSection + " section of the supplied JAAS configuration: '" + System.getProperty("java.security.auth.login.config") + "' because of a RuntimeException: " + runtimeException);
                }
                throw new LoginException("Client cannot SASL-authenticate because the specified JAAS configuration section '" + explicitClientSection + "' could not be found.");
            }
            String msg = "Will not attempt to authenticate using SASL ";
            msg = runtimeException != null ? msg + "(" + runtimeException + ")" : msg + "(unknown error)";
            this.configStatus = msg;
            this.isSASLConfigured = false;
            if (System.getProperty("java.security.auth.login.config") != null) {
                if (runtimeException != null) {
                    throw new LoginException("Zookeeper client cannot authenticate using the '" + System.getProperty(LOGIN_CONTEXT_NAME_KEY, "Client") + "' section of the supplied JAAS configuration: '" + System.getProperty("java.security.auth.login.config") + "' because of a RuntimeException: " + runtimeException);
                }
                throw new LoginException("No JAAS configuration section named '" + System.getProperty(LOGIN_CONTEXT_NAME_KEY, "Client") + "' was found in specified JAAS configuration file: '" + System.getProperty("java.security.auth.login.config") + "'.");
            }
        }
    }

    public String getConfigStatus() {
        return this.configStatus;
    }

    public boolean isComplete() {
        return this.saslState == SaslState.COMPLETE;
    }

    public boolean isFailed() {
        return this.saslState == SaslState.FAILED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private SaslClient createSaslClient(String servicePrincipal, String loginContext) throws LoginException {
        try {
            if (initializedLogin) return SecurityUtils.createSaslClient(login.getSubject(), servicePrincipal, "zookeeper", "zk-sasl-md5", LOG, "Client");
            Class<ZooKeeperSaslClient> clazz = ZooKeeperSaslClient.class;
            synchronized (ZooKeeperSaslClient.class) {
                if (login != null) return SecurityUtils.createSaslClient(login.getSubject(), servicePrincipal, "zookeeper", "zk-sasl-md5", LOG, "Client");
                if (LOG.isDebugEnabled()) {
                    LOG.debug("JAAS loginContext is: " + loginContext);
                }
                login = new Login(loginContext, new SaslClientCallbackHandler(null, "Client"));
                login.startThreadIfNeeded();
                initializedLogin = true;
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return SecurityUtils.createSaslClient(login.getSubject(), servicePrincipal, "zookeeper", "zk-sasl-md5", LOG, "Client");
            }
        }
        catch (LoginException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error("Exception while trying to create SASL client: " + e);
            return null;
        }
    }

    public void respondToServer(byte[] serverToken, ClientCnxn cnxn) {
        if (this.saslClient == null) {
            LOG.error("saslClient is unexpectedly null. Cannot respond to server's SASL message; ignoring.");
            return;
        }
        if (!this.saslClient.isComplete()) {
            try {
                this.saslToken = this.createSaslToken(serverToken);
                if (this.saslToken != null) {
                    this.sendSaslPacket(this.saslToken, cnxn);
                }
            }
            catch (SaslException e) {
                LOG.error("SASL authentication failed using login context '" + this.getLoginContext() + "' with exception: {}", e);
                this.saslState = SaslState.FAILED;
                this.gotLastPacket = true;
            }
        }
        if (this.saslClient.isComplete()) {
            if (serverToken == null && this.saslClient.getMechanismName().equals("GSSAPI")) {
                this.gotLastPacket = true;
            }
            if (!this.saslClient.getMechanismName().equals("GSSAPI")) {
                this.gotLastPacket = true;
            }
            cnxn.enableWrite();
        }
    }

    private byte[] createSaslToken() throws SaslException {
        this.saslState = SaslState.INTERMEDIATE;
        return this.createSaslToken(this.saslToken);
    }

    private byte[] createSaslToken(final byte[] saslToken) throws SaslException {
        if (saslToken == null) {
            this.saslState = SaslState.FAILED;
            throw new SaslException("Error in authenticating with a Zookeeper Quorum member: the quorum member's saslToken is null.");
        }
        Subject subject = login.getSubject();
        if (subject != null) {
            Login login = ZooKeeperSaslClient.login;
            synchronized (login) {
                try {
                    byte[] retval = Subject.doAs(subject, new PrivilegedExceptionAction<byte[]>(){

                        @Override
                        public byte[] run() throws SaslException {
                            LOG.debug("saslClient.evaluateChallenge(len=" + saslToken.length + ")");
                            return ZooKeeperSaslClient.this.saslClient.evaluateChallenge(saslToken);
                        }
                    });
                    return retval;
                }
                catch (PrivilegedActionException e) {
                    String error = "An error: (" + e + ") occurred when evaluating Zookeeper Quorum Member's  received SASL token.";
                    String UNKNOWN_SERVER_ERROR_TEXT = "(Mechanism level: Server not found in Kerberos database (7) - UNKNOWN_SERVER)";
                    if (e.toString().indexOf("(Mechanism level: Server not found in Kerberos database (7) - UNKNOWN_SERVER)") > -1) {
                        error = error + " This may be caused by Java's being unable to resolve the Zookeeper Quorum Member's hostname correctly. You may want to try to adding '-Dsun.net.spi.nameservice.provider.1=dns,sun' to your client's JVMFLAGS environment.";
                    }
                    error = error + " Zookeeper Client will go to AUTH_FAILED state.";
                    LOG.error(error);
                    this.saslState = SaslState.FAILED;
                    throw new SaslException(error);
                }
            }
        }
        throw new SaslException("Cannot make SASL token without subject defined. For diagnosis, please look for WARNs and ERRORs in your log related to the Login class.");
    }

    private void sendSaslPacket(byte[] saslToken, ClientCnxn cnxn) throws SaslException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("ClientCnxn:sendSaslPacket:length=" + saslToken.length);
        }
        GetSASLRequest request = new GetSASLRequest();
        request.setToken(saslToken);
        SetSASLResponse response = new SetSASLResponse();
        ServerSaslResponseCallback cb = new ServerSaslResponseCallback();
        try {
            cnxn.sendPacket(request, response, cb, 102);
        }
        catch (IOException e) {
            throw new SaslException("Failed to send SASL packet to server.", e);
        }
    }

    private void sendSaslPacket(ClientCnxn cnxn) throws SaslException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("ClientCnxn:sendSaslPacket:length=" + this.saslToken.length);
        }
        GetSASLRequest request = new GetSASLRequest();
        request.setToken(this.createSaslToken());
        SetSASLResponse response = new SetSASLResponse();
        ServerSaslResponseCallback cb = new ServerSaslResponseCallback();
        try {
            cnxn.sendPacket(request, response, cb, 102);
        }
        catch (IOException e) {
            throw new SaslException("Failed to send SASL packet to server due to IOException:", e);
        }
    }

    public Watcher.Event.KeeperState getKeeperState() {
        if (this.saslClient != null) {
            if (this.saslState == SaslState.FAILED) {
                return Watcher.Event.KeeperState.AuthFailed;
            }
            if (this.saslClient.isComplete() && this.saslState == SaslState.INTERMEDIATE) {
                this.saslState = SaslState.COMPLETE;
                return Watcher.Event.KeeperState.SaslAuthenticated;
            }
        }
        return null;
    }

    public void initialize(ClientCnxn cnxn) throws SaslException {
        if (this.saslClient == null) {
            this.saslState = SaslState.FAILED;
            throw new SaslException("saslClient failed to initialize properly: it's null.");
        }
        if (this.saslState == SaslState.INITIAL) {
            if (this.saslClient.hasInitialResponse()) {
                this.sendSaslPacket(cnxn);
            } else {
                byte[] emptyToken = new byte[]{};
                this.sendSaslPacket(emptyToken, cnxn);
            }
            this.saslState = SaslState.INTERMEDIATE;
        }
    }

    public boolean clientTunneledAuthenticationInProgress() {
        if (!this.isSASLConfigured) {
            return false;
        }
        try {
            if (System.getProperty("java.security.auth.login.config") != null || Configuration.getConfiguration() != null && Configuration.getConfiguration().getAppConfigurationEntry(System.getProperty(LOGIN_CONTEXT_NAME_KEY, "Client")) != null) {
                if (!this.isComplete() && !this.isFailed()) {
                    return true;
                }
                if ((this.isComplete() || this.isFailed()) && !this.gotLastPacket) {
                    return true;
                }
            }
            return false;
        }
        catch (SecurityException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Could not retrieve login configuration: " + e);
            }
            return false;
        }
    }

    public static class ServerSaslResponseCallback
    implements AsyncCallback.DataCallback {
        @Override
        public void processResult(int rc, String path, Object ctx, byte[] data2, Stat stat) {
            ZooKeeperSaslClient client = ((ClientCnxn)ctx).zooKeeperSaslClient;
            if (client == null) {
                LOG.warn("sasl client was unexpectedly null: cannot respond to Zookeeper server.");
                return;
            }
            byte[] usedata = data2;
            if (data2 != null) {
                LOG.debug("ServerSaslResponseCallback(): saslToken server response: (length=" + usedata.length + ")");
            } else {
                usedata = new byte[]{};
                LOG.debug("ServerSaslResponseCallback(): using empty data[] as server response (length=" + usedata.length + ")");
            }
            client.respondToServer(usedata, (ClientCnxn)ctx);
        }
    }

    public static enum SaslState {
        INITIAL,
        INTERMEDIATE,
        COMPLETE,
        FAILED;

    }
}

