/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.streaming;

import java.io.IOException;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.SerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeUtils;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hive.hcatalog.data.JsonSerDe;
import org.apache.hive.hcatalog.streaming.AbstractRecordWriter;
import org.apache.hive.hcatalog.streaming.ConnectionError;
import org.apache.hive.hcatalog.streaming.HiveEndPoint;
import org.apache.hive.hcatalog.streaming.SerializationError;
import org.apache.hive.hcatalog.streaming.StreamingException;
import org.apache.hive.hcatalog.streaming.StreamingIOFailure;

public class StrictJsonWriter
extends AbstractRecordWriter {
    private JsonSerDe serde;

    public StrictJsonWriter(HiveEndPoint endPoint) throws ConnectionError, SerializationError, StreamingException {
        super(endPoint, null);
    }

    public StrictJsonWriter(HiveEndPoint endPoint, HiveConf conf) throws ConnectionError, SerializationError, StreamingException {
        super(endPoint, conf);
    }

    @Override
    SerDe getSerde() throws SerializationError {
        if (this.serde != null) {
            return this.serde;
        }
        this.serde = StrictJsonWriter.createSerde(this.tbl, this.conf);
        return this.serde;
    }

    @Override
    public void write(long transactionId, byte[] record) throws StreamingIOFailure, SerializationError {
        try {
            Object encodedRow = this.encode(record);
            this.updater.insert(transactionId, encodedRow);
        }
        catch (IOException e) {
            throw new StreamingIOFailure("Error writing record in transaction(" + transactionId + ")", e);
        }
    }

    private static JsonSerDe createSerde(Table tbl, HiveConf conf) throws SerializationError {
        try {
            Properties tableProps = MetaStoreUtils.getTableMetadata((Table)tbl);
            JsonSerDe serde = new JsonSerDe();
            SerDeUtils.initializeSerDe((Deserializer)serde, (Configuration)conf, (Properties)tableProps, null);
            return serde;
        }
        catch (SerDeException e) {
            throw new SerializationError("Error initializing serde " + JsonSerDe.class.getName(), (Exception)((Object)e));
        }
    }

    private Object encode(byte[] utf8StrRecord) throws SerializationError {
        try {
            Text blob = new Text(utf8StrRecord);
            return this.serde.deserialize((Writable)blob);
        }
        catch (SerDeException e) {
            throw new SerializationError("Unable to convert byte[] record into Object", (Exception)((Object)e));
        }
    }
}

