/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.aot;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.aot.AotDetector;
import org.springframework.lang.Nullable;
import org.springframework.test.context.aot.AotTestAttributesCodeGenerator;
import org.springframework.test.context.aot.GeneratedMapUtils;

final class AotTestAttributesFactory {
    @Nullable
    private static volatile Map<String, String> attributes;

    private AotTestAttributesFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Map<String, String> getAttributes() {
        ConcurrentHashMap<String, String> attrs = attributes;
        if (attrs != null) return attrs;
        Class<AotTestAttributesFactory> clazz = AotTestAttributesFactory.class;
        synchronized (AotTestAttributesFactory.class) {
            attrs = attributes;
            if (attrs != null) return attrs;
            attrs = AotDetector.useGeneratedArtifacts() ? AotTestAttributesFactory.loadAttributesMap() : new ConcurrentHashMap<String, String>();
            attributes = attrs;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return attrs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void reset() {
        Class<AotTestAttributesFactory> clazz = AotTestAttributesFactory.class;
        synchronized (AotTestAttributesFactory.class) {
            attributes = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static Map<String, String> loadAttributesMap() {
        String className = AotTestAttributesCodeGenerator.GENERATED_ATTRIBUTES_CLASS_NAME;
        String methodName = "getAttributes";
        return GeneratedMapUtils.loadMap(className, methodName);
    }
}

