/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.renderers;

import java.util.List;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.ioc.annotations.Primary;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.services.Context;
import org.apache.tapestry5.services.ObjectRenderer;
import org.apache.tapestry5.services.Request;

public class RequestRenderer
implements ObjectRenderer<Request> {
    private final Context context;
    private final String contextPath;
    private final ObjectRenderer masterObjectRenderer;

    public RequestRenderer(@Primary ObjectRenderer masterObjectRenderer, Context context, @Symbol(value="tapestry.context-path") String contextPath) {
        this.masterObjectRenderer = masterObjectRenderer;
        this.context = context;
        this.contextPath = contextPath;
    }

    @Override
    public void render(Request request, MarkupWriter writer) {
        this.coreProperties(request, writer);
        this.parameters(request, writer);
        this.headers(request, writer);
        this.attributes(request, writer);
        this.context(writer);
    }

    private void coreProperties(Request request, MarkupWriter writer) {
        writer.element("dl", "class", "dl-horizontal");
        this.dt(writer, "Context Path");
        writer.element("dd", new Object[0]);
        if (this.contextPath.equals("")) {
            writer.element("em", new Object[0]);
            writer.write("none (deployed as root)");
            writer.end();
        } else {
            writer.write(this.contextPath);
        }
        writer.end();
        this.dt(writer, "Path", request.getPath());
        this.dt(writer, "Locale", request.getLocale().toString());
        this.dt(writer, "Server Name", request.getServerName());
        List flags = CollectionFactory.newList();
        if (request.isSecure()) {
            flags.add("secure");
        }
        if (request.isXHR()) {
            flags.add("XHR");
        }
        if (request.isRequestedSessionIdValid()) {
            flags.add("requested session id valid");
        }
        if (request.isSessionInvalidated()) {
            flags.add("session invalidated");
        }
        if (!flags.isEmpty()) {
            this.dt(writer, "Flags", InternalUtils.join((List)flags));
        }
        this.dt(writer, "Ports (local/server)", String.format("%d / %d", request.getLocalPort(), request.getServerPort()));
        this.dt(writer, "Method", request.getMethod());
        writer.end();
    }

    private void context(MarkupWriter writer) {
        List<String> attributeNames = this.context.getAttributeNames();
        if (attributeNames.isEmpty()) {
            return;
        }
        this.section(writer, "Context Attributes");
        writer.element("dl", new Object[0]);
        for (String name : attributeNames) {
            this.dt(writer, name);
            writer.element("dd", new Object[0]);
            this.masterObjectRenderer.render(this.context.getAttribute(name), writer);
            writer.end();
        }
        writer.end();
    }

    private void parameters(Request request, MarkupWriter writer) {
        List<String> parameterNames = request.getParameterNames();
        if (parameterNames.isEmpty()) {
            return;
        }
        this.section(writer, "Query Parameters");
        writer.element("dl", new Object[0]);
        for (String name : parameterNames) {
            String[] values = request.getParameters(name);
            this.dt(writer, name);
            writer.element("dd", new Object[0]);
            if (values.length > 1) {
                writer.element("ul", new Object[0]);
                for (String value : values) {
                    writer.element("li", new Object[0]);
                    writer.write(value);
                    writer.end();
                }
                writer.end();
            } else {
                writer.write(values[0]);
            }
            writer.end();
        }
        writer.end();
    }

    private void dt(MarkupWriter writer, String name, String value) {
        if (value != null) {
            this.dt(writer, name);
            this.dd(writer, value);
        }
    }

    private void dt(MarkupWriter writer, String name) {
        writer.element("dt", new Object[0]);
        writer.write(name);
        writer.end();
    }

    private void dd(MarkupWriter writer, String name) {
        writer.element("dd", new Object[0]);
        writer.write(name);
        writer.end();
    }

    private void section(MarkupWriter writer, String name) {
        writer.element("h3", new Object[0]);
        writer.write(name);
        writer.end();
    }

    private void headers(Request request, MarkupWriter writer) {
        this.section(writer, "Headers");
        writer.element("dl", "class", "dl-horizontal");
        for (String name : request.getHeaderNames()) {
            this.dt(writer, name, request.getHeader(name));
        }
        writer.end();
    }

    private void attributes(Request request, MarkupWriter writer) {
        List<String> attributeNames = request.getAttributeNames();
        if (attributeNames.isEmpty()) {
            return;
        }
        this.section(writer, "Attributes");
        writer.element("dl", new Object[0]);
        for (String name : attributeNames) {
            this.dt(writer, name, String.valueOf(request.getAttribute(name)));
        }
        writer.end();
    }
}

