/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.lang.ref.SoftReference;
import java.util.Map;
import java.util.Set;
import org.apache.tapestry5.func.F;
import org.apache.tapestry5.func.Flow;
import org.apache.tapestry5.func.Mapper;
import org.apache.tapestry5.internal.services.PageLoader;
import org.apache.tapestry5.internal.services.PageSource;
import org.apache.tapestry5.internal.services.assets.ResourceChangeTracker;
import org.apache.tapestry5.internal.structure.Page;
import org.apache.tapestry5.ioc.annotations.PostInjection;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.services.ComponentClasses;
import org.apache.tapestry5.services.ComponentMessages;
import org.apache.tapestry5.services.ComponentTemplates;
import org.apache.tapestry5.services.InvalidationEventHub;
import org.apache.tapestry5.services.pageload.ComponentRequestSelectorAnalyzer;
import org.apache.tapestry5.services.pageload.ComponentResourceSelector;

public class PageSourceImpl
implements PageSource {
    private final ComponentRequestSelectorAnalyzer selectorAnalyzer;
    private final PageLoader pageLoader;
    private final Map<CachedPageKey, SoftReference<Page>> pageCache = CollectionFactory.newConcurrentMap();

    public PageSourceImpl(PageLoader pageLoader, ComponentRequestSelectorAnalyzer selectorAnalyzer) {
        this.pageLoader = pageLoader;
        this.selectorAnalyzer = selectorAnalyzer;
    }

    @Override
    public Page getPage(String canonicalPageName) {
        ComponentResourceSelector selector = this.selectorAnalyzer.buildSelectorForRequest();
        CachedPageKey key = new CachedPageKey(canonicalPageName, selector);
        while (true) {
            SoftReference<Page> ref;
            Page page;
            Page page2 = page = (ref = this.pageCache.get(key)) == null ? null : ref.get();
            if (page != null) {
                return page;
            }
            page = this.pageLoader.loadPage(canonicalPageName, selector);
            ref = new SoftReference<Page>(page);
            this.pageCache.put(key, ref);
        }
    }

    @PostInjection
    public void setupInvalidation(@ComponentClasses InvalidationEventHub classesHub, @ComponentTemplates InvalidationEventHub templatesHub, @ComponentMessages InvalidationEventHub messagesHub, ResourceChangeTracker resourceChangeTracker) {
        classesHub.clearOnInvalidation(this.pageCache);
        templatesHub.clearOnInvalidation(this.pageCache);
        messagesHub.clearOnInvalidation(this.pageCache);
        resourceChangeTracker.clearOnInvalidation(this.pageCache);
    }

    @Override
    public void clearCache() {
        this.pageCache.clear();
    }

    @Override
    public Set<Page> getAllPages() {
        return ((Flow)F.flow(this.pageCache.values()).map((Mapper)new Mapper<SoftReference<Page>, Page>(){

            public Page map(SoftReference<Page> element) {
                return element.get();
            }
        }).removeNulls()).toSet();
    }

    private static final class CachedPageKey {
        final String pageName;
        final ComponentResourceSelector selector;

        public CachedPageKey(String pageName, ComponentResourceSelector selector) {
            this.pageName = pageName;
            this.selector = selector;
        }

        public int hashCode() {
            return 37 * this.pageName.hashCode() + this.selector.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof CachedPageKey)) {
                return false;
            }
            CachedPageKey other = (CachedPageKey)obj;
            return this.pageName.equals(other.pageName) && this.selector.equals(other.selector);
        }
    }
}

