/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.structure;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.tapestry5.Binding;
import org.apache.tapestry5.Binding2;
import org.apache.tapestry5.Block;
import org.apache.tapestry5.ComponentEventCallback;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.EventContext;
import org.apache.tapestry5.Link;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.func.Worker;
import org.apache.tapestry5.internal.InternalComponentResources;
import org.apache.tapestry5.internal.bindings.InternalPropBinding;
import org.apache.tapestry5.internal.bindings.PropBinding;
import org.apache.tapestry5.internal.services.Instantiator;
import org.apache.tapestry5.internal.structure.ComponentPageElement;
import org.apache.tapestry5.internal.structure.ComponentPageElementResources;
import org.apache.tapestry5.internal.structure.Page;
import org.apache.tapestry5.internal.structure.PageResetListener;
import org.apache.tapestry5.internal.structure.StructureMessages;
import org.apache.tapestry5.internal.transform.ParameterConduit;
import org.apache.tapestry5.internal.util.NamedSet;
import org.apache.tapestry5.ioc.AnnotationProvider;
import org.apache.tapestry5.ioc.Location;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.Resource;
import org.apache.tapestry5.ioc.internal.NullAnnotationProvider;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.ioc.internal.util.LockSupport;
import org.apache.tapestry5.ioc.internal.util.TapestryException;
import org.apache.tapestry5.ioc.services.PerThreadValue;
import org.apache.tapestry5.model.ComponentModel;
import org.apache.tapestry5.runtime.Component;
import org.apache.tapestry5.runtime.PageLifecycleCallbackHub;
import org.apache.tapestry5.runtime.PageLifecycleListener;
import org.apache.tapestry5.runtime.RenderQueue;
import org.apache.tapestry5.services.pageload.ComponentResourceSelector;
import org.slf4j.Logger;

public class InternalComponentResourcesImpl
extends LockSupport
implements InternalComponentResources {
    private final Page page;
    private final String completeId;
    private final String nestedId;
    private final ComponentModel componentModel;
    private final ComponentPageElement element;
    private final Component component;
    private final ComponentResources containerResources;
    private final ComponentPageElementResources elementResources;
    private final boolean mixin;
    private static final Object[] EMPTY = new Object[0];
    private static final AnnotationProvider NULL_ANNOTATION_PROVIDER = new NullAnnotationProvider();
    private NamedSet<Binding> bindings;
    private NamedSet<ParameterConduit> conduits;
    private Messages messages;
    private boolean informalsComputed;
    private PerThreadValue<Map<String, Object>> renderVariables;
    private Informal firstInformal;
    private static Worker<ParameterConduit> RESET_PARAMETER_CONDUIT = new Worker<ParameterConduit>(){

        public void work(ParameterConduit value) {
            value.reset();
        }
    };

    public InternalComponentResourcesImpl(Page page, ComponentPageElement element, ComponentResources containerResources, ComponentPageElementResources elementResources, String completeId, String nestedId, Instantiator componentInstantiator, boolean mixin) {
        this.page = page;
        this.element = element;
        this.containerResources = containerResources;
        this.elementResources = elementResources;
        this.completeId = completeId;
        this.nestedId = nestedId;
        this.mixin = mixin;
        this.componentModel = componentInstantiator.getModel();
        this.component = componentInstantiator.newInstance(this);
    }

    @Override
    public boolean isMixin() {
        return this.mixin;
    }

    public Location getLocation() {
        return this.element.getLocation();
    }

    public String toString() {
        return String.format("InternalComponentResources[%s]", this.getCompleteId());
    }

    @Override
    public ComponentModel getComponentModel() {
        return this.componentModel;
    }

    @Override
    public Component getEmbeddedComponent(String embeddedId) {
        return this.element.getEmbeddedElement(embeddedId).getComponent();
    }

    @Override
    public Object getFieldChange(String fieldName) {
        return this.page.getFieldChange(this.nestedId, fieldName);
    }

    @Override
    public String getId() {
        return this.element.getId();
    }

    @Override
    public boolean hasFieldChange(String fieldName) {
        return this.getFieldChange(fieldName) != null;
    }

    @Override
    public Link createEventLink(String eventType, Object ... context) {
        return this.element.createEventLink(eventType, context);
    }

    @Override
    public Link createFormEventLink(String eventType, Object ... context) {
        return this.element.createFormEventLink(eventType, context);
    }

    @Override
    public void discardPersistentFieldChanges() {
        this.page.discardPersistentFieldChanges();
    }

    @Override
    public String getElementName() {
        return this.getElementName(null);
    }

    @Override
    public List<String> getInformalParameterNames() {
        return InternalUtils.sortedKeys(this.getInformalParameterBindings());
    }

    @Override
    public <T> T getInformalParameter(String name, Class<T> type) {
        Binding binding = this.getBinding(name);
        Object value = binding == null ? null : binding.get();
        return this.elementResources.coerce(value, type);
    }

    @Override
    public Block getBody() {
        return this.element.getBody();
    }

    @Override
    public boolean hasBody() {
        return this.element.hasBody();
    }

    @Override
    public String getCompleteId() {
        return this.completeId;
    }

    @Override
    public Component getComponent() {
        return this.component;
    }

    @Override
    public boolean isBound(String parameterName) {
        return this.getBinding(parameterName) != null;
    }

    @Override
    public <T extends Annotation> T getParameterAnnotation(String parameterName, Class<T> annotationType) {
        Binding binding = this.getBinding(parameterName);
        return (T)(binding == null ? null : binding.getAnnotation(annotationType));
    }

    @Override
    public boolean isRendering() {
        return this.element.isRendering();
    }

    @Override
    public boolean triggerEvent(String eventType, Object[] context, ComponentEventCallback handler) {
        return this.element.triggerEvent(eventType, InternalComponentResourcesImpl.defaulted(context), handler);
    }

    private static Object[] defaulted(Object[] input) {
        return input == null ? EMPTY : input;
    }

    @Override
    public boolean triggerContextEvent(String eventType, EventContext context, ComponentEventCallback callback) {
        return this.element.triggerContextEvent(eventType, context, callback);
    }

    @Override
    public String getNestedId() {
        return this.nestedId;
    }

    @Override
    public Component getPage() {
        return this.element.getContainingPage().getRootComponent();
    }

    @Override
    public boolean isLoaded() {
        return this.element.isLoaded();
    }

    @Override
    public void persistFieldChange(String fieldName, Object newValue) {
        try {
            this.page.persistFieldChange(this, fieldName, newValue);
        }
        catch (Exception ex) {
            throw new TapestryException(StructureMessages.fieldPersistFailure(this.getCompleteId(), fieldName, ex), this.getLocation(), (Throwable)ex);
        }
    }

    @Override
    public void bindParameter(String parameterName, Binding binding) {
        if (this.bindings == null) {
            this.bindings = NamedSet.create();
        }
        this.bindings.put(parameterName, binding);
    }

    @Override
    public Class getBoundType(String parameterName) {
        Binding binding = this.getBinding(parameterName);
        return binding == null ? null : binding.getBindingType();
    }

    @Override
    public Type getBoundGenericType(String parameterName) {
        Binding binding = this.getBinding(parameterName);
        Type genericType = binding instanceof Binding2 ? ((Binding2)binding).getBindingGenericType() : binding.getBindingType();
        return genericType;
    }

    @Override
    public Binding getBinding(String parameterName) {
        return NamedSet.get(this.bindings, parameterName);
    }

    @Override
    public AnnotationProvider getAnnotationProvider(String parameterName) {
        Binding binding = this.getBinding(parameterName);
        return binding == null ? NULL_ANNOTATION_PROVIDER : binding;
    }

    @Override
    public Logger getLogger() {
        return this.componentModel.getLogger();
    }

    @Override
    public Component getMixinByClassName(String mixinClassName) {
        return this.element.getMixinByClassName(mixinClassName);
    }

    @Override
    public void renderInformalParameters(MarkupWriter writer) {
        if (this.bindings == null) {
            return;
        }
        Informal i = this.firstInformal();
        while (i != null) {
            i.write(writer);
            i = i.next;
        }
    }

    private Informal firstInformal() {
        try {
            this.acquireReadLock();
            if (!this.informalsComputed) {
                this.computeInformals();
            }
            Informal informal = this.firstInformal;
            return informal;
        }
        finally {
            this.releaseReadLock();
        }
    }

    private void computeInformals() {
        try {
            this.upgradeReadLockToWriteLock();
            if (!this.informalsComputed) {
                for (Map.Entry<String, Binding> e : this.getInformalParameterBindings().entrySet()) {
                    this.firstInformal = new Informal(e.getKey(), e.getValue(), this.firstInformal);
                }
                this.informalsComputed = true;
            }
        }
        finally {
            this.downgradeWriteLockToReadLock();
        }
    }

    @Override
    public Component getContainer() {
        if (this.containerResources == null) {
            return null;
        }
        return this.containerResources.getComponent();
    }

    @Override
    public ComponentResources getContainerResources() {
        return this.containerResources;
    }

    @Override
    public Messages getContainerMessages() {
        return this.containerResources != null ? this.containerResources.getMessages() : null;
    }

    @Override
    public Locale getLocale() {
        return this.element.getLocale();
    }

    @Override
    public ComponentResourceSelector getResourceSelector() {
        return this.element.getResourceSelector();
    }

    @Override
    public Messages getMessages() {
        if (this.messages == null) {
            this.messages = this.elementResources.getMessages(this.componentModel);
        }
        return this.messages;
    }

    @Override
    public String getElementName(String defaultElementName) {
        return this.element.getElementName(defaultElementName);
    }

    @Override
    public Block getBlock(String blockId) {
        return this.element.getBlock(blockId);
    }

    @Override
    public Block getBlockParameter(String parameterName) {
        return this.getInformalParameter(parameterName, Block.class);
    }

    @Override
    public Block findBlock(String blockId) {
        return this.element.findBlock(blockId);
    }

    @Override
    public Resource getBaseResource() {
        return this.componentModel.getBaseResource();
    }

    @Override
    public String getPageName() {
        return this.element.getPageName();
    }

    @Override
    public Map<String, Binding> getInformalParameterBindings() {
        Map result = CollectionFactory.newMap();
        for (String name : NamedSet.getNames(this.bindings)) {
            if (this.componentModel.getParameterModel(name) != null) continue;
            result.put(name, this.bindings.get(name));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> getRenderVariables(boolean create) {
        try {
            Map result;
            this.acquireReadLock();
            if (this.renderVariables == null) {
                if (!create) {
                    Map<String, Object> map = null;
                    return map;
                }
                this.createRenderVariablesPerThreadValue();
            }
            if ((result = (Map)this.renderVariables.get()) == null && create) {
                result = (Map)this.renderVariables.set((Object)CollectionFactory.newCaseInsensitiveMap());
            }
            Map map = result;
            return map;
        }
        finally {
            this.releaseReadLock();
        }
    }

    private void createRenderVariablesPerThreadValue() {
        try {
            this.upgradeReadLockToWriteLock();
            if (this.renderVariables == null) {
                this.renderVariables = this.elementResources.createPerThreadValue();
            }
        }
        finally {
            this.downgradeWriteLockToReadLock();
        }
    }

    @Override
    public Object getRenderVariable(String name) {
        Map<String, Object> variablesMap = this.getRenderVariables(false);
        Object result = InternalUtils.get(variablesMap, (Object)name);
        if (result == null) {
            throw new IllegalArgumentException(StructureMessages.missingRenderVariable(this.getCompleteId(), name, variablesMap == null ? null : variablesMap.keySet()));
        }
        return result;
    }

    @Override
    public void storeRenderVariable(String name, Object value) {
        assert (InternalUtils.isNonBlank((String)name));
        assert (value != null);
        Map<String, Object> renderVariables = this.getRenderVariables(true);
        renderVariables.put(name, value);
    }

    @Override
    public void postRenderCleanup() {
        Map<String, Object> variablesMap = this.getRenderVariables(false);
        if (variablesMap != null) {
            variablesMap.clear();
        }
        this.resetParameterConduits();
    }

    @Override
    public void addPageLifecycleListener(PageLifecycleListener listener) {
        this.page.addLifecycleListener(listener);
    }

    @Override
    public void removePageLifecycleListener(PageLifecycleListener listener) {
        this.page.removeLifecycleListener(listener);
    }

    @Override
    public void addPageResetListener(PageResetListener listener) {
        this.page.addResetListener(listener);
    }

    private void resetParameterConduits() {
        try {
            this.acquireReadLock();
            if (this.conduits != null) {
                this.conduits.eachValue(RESET_PARAMETER_CONDUIT);
            }
        }
        finally {
            this.releaseReadLock();
        }
    }

    @Override
    public ParameterConduit getParameterConduit(String parameterName) {
        try {
            this.acquireReadLock();
            ParameterConduit parameterConduit = NamedSet.get(this.conduits, parameterName);
            return parameterConduit;
        }
        finally {
            this.releaseReadLock();
        }
    }

    @Override
    public void setParameterConduit(String parameterName, ParameterConduit conduit) {
        try {
            this.acquireReadLock();
            if (this.conduits == null) {
                this.createConduits();
            }
            this.conduits.put(parameterName, conduit);
        }
        finally {
            this.releaseReadLock();
        }
    }

    private void createConduits() {
        try {
            this.upgradeReadLockToWriteLock();
            if (this.conduits == null) {
                this.conduits = NamedSet.create();
            }
        }
        finally {
            this.downgradeWriteLockToReadLock();
        }
    }

    @Override
    public String getPropertyName(String parameterName) {
        Binding binding = this.getBinding(parameterName);
        if (binding == null) {
            return null;
        }
        if (binding instanceof PropBinding) {
            return ((PropBinding)binding).getExpression();
        }
        if (binding instanceof InternalPropBinding) {
            return ((InternalPropBinding)binding).getPropertyName();
        }
        return null;
    }

    @Override
    public void render(MarkupWriter writer, RenderQueue queue) {
        queue.push(this.element);
    }

    @Override
    public PageLifecycleCallbackHub getPageLifecycleCallbackHub() {
        return this.page;
    }

    private class Informal {
        private final String name;
        private final Binding binding;
        final Informal next;

        private Informal(String name, Binding binding, Informal next) {
            this.name = name;
            this.binding = binding;
            this.next = next;
        }

        void write(MarkupWriter writer) {
            Object value = this.binding.get();
            if (value == null) {
                return;
            }
            if (value instanceof Block) {
                return;
            }
            String valueString = value instanceof String ? (String)value : InternalComponentResourcesImpl.this.elementResources.coerce(value, String.class);
            writer.attributes(this.name, valueString);
        }
    }
}

