/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.tapestry5.internal.services.ComponentDependencyGraphvizGenerator;
import org.apache.tapestry5.internal.services.ComponentDependencyRegistry;
import org.apache.tapestry5.services.ComponentClassResolver;

public class ComponentDependencyGraphvizGeneratorImpl
implements ComponentDependencyGraphvizGenerator {
    private final ComponentClassResolver componentClassResolver;
    private final ComponentDependencyRegistry componentDependencyRegistry;

    public ComponentDependencyGraphvizGeneratorImpl(ComponentDependencyRegistry componentDependencyRegistry, ComponentClassResolver componentClassResolver) {
        this.componentDependencyRegistry = componentDependencyRegistry;
        this.componentClassResolver = componentClassResolver;
    }

    @Override
    public String generate(String ... classNames) {
        StringBuilder dotFile = new StringBuilder("digraph {\n\n");
        dotFile.append("\trankdir=LR;\n");
        dotFile.append("\tfontname=\"Helvetica,Arial,sans-serif\";\n");
        dotFile.append("\tsplines=ortho;\n\n");
        dotFile.append("\tnode [fontname=\"Helvetica,Arial,sans-serif\",fontsize=\"10pt\"];\n");
        dotFile.append("\tnode [shape=rect];\n\n");
        HashSet<String> allClasses = new HashSet<String>();
        HashMap<String, Node> nodeMap = new HashMap<String, Node>();
        for (String className : classNames) {
            this.createNode(className, nodeMap);
            for (ComponentDependencyRegistry.DependencyType dependencyType : ComponentDependencyRegistry.DependencyType.values()) {
                this.addDependencies(className, allClasses, dependencyType, nodeMap);
            }
        }
        ArrayList nodes = new ArrayList(nodeMap.values());
        Collections.sort(nodes, Comparator.comparing(n -> ((Node)n).id));
        for (Node node : nodes) {
            dotFile.append(this.getNodeDefinition(node));
        }
        dotFile.append("\n");
        for (Node node : nodes) {
            for (Dependency dependency : node.dependencies) {
                dotFile.append(this.getNodeDependencyDefinition(node, dependency.className, dependency.type));
            }
        }
        dotFile.append("\n");
        dotFile.append("}");
        return dotFile.toString();
    }

    private String getNodeDefinition(Node node) {
        return String.format("\t%s [label=\"%s\", tooltip=\"%s\"];\n", node.id, node.label, node.className);
    }

    private String getNodeDependencyDefinition(Node node, String dependency, ComponentDependencyRegistry.DependencyType dependencyType) {
        String extraDefinition;
        switch (dependencyType) {
            case INJECT_PAGE: {
                extraDefinition = " [style=dashed]";
                break;
            }
            case SUPERCLASS: {
                extraDefinition = " [arrowhead=empty]";
                break;
            }
            default: {
                extraDefinition = "";
            }
        }
        return String.format("\t%s -> %s%s\n", node.id, ComponentDependencyGraphvizGeneratorImpl.escapeNodeId(this.getNodeLabel(dependency)), extraDefinition);
    }

    private String getNodeLabel(String className) {
        String logicalName = this.componentClassResolver.getLogicalName(className);
        return ComponentDependencyGraphvizGeneratorImpl.getNodeLabel(className, logicalName, false);
    }

    private static String getNodeLabel(String className, String logicalName, boolean beautify) {
        return logicalName != null ? ComponentDependencyGraphvizGeneratorImpl.beautifyLogicalName(logicalName) : (beautify ? ComponentDependencyGraphvizGeneratorImpl.beautifyClassName(className) : className);
    }

    private static String beautifyLogicalName(String logicalName) {
        return logicalName.startsWith("core/") ? logicalName.replace("core/", "") : logicalName;
    }

    private static String beautifyClassName(String className) {
        String name = className.substring(className.lastIndexOf(46) + 1);
        if (className.contains(".base.")) {
            name = name + " (base class)";
        } else if (className.contains(".mixins.")) {
            name = name + " (mixin)";
        }
        return name;
    }

    private static String escapeNodeId(String label) {
        return label.replace('.', '_').replace('/', '_');
    }

    private void addDependencies(String className, Set<String> allClasses, ComponentDependencyRegistry.DependencyType type, Map<String, Node> nodeMap) {
        if (!allClasses.contains(className)) {
            this.createNode(className, nodeMap);
            for (String dependency : this.componentDependencyRegistry.getDependencies(className, type)) {
                this.addDependencies(dependency, allClasses, type, nodeMap);
            }
            allClasses.add(className);
        }
    }

    private void createNode(String className, Map<String, Node> nodeMap) {
        if (!nodeMap.containsKey(className)) {
            HashSet<Dependency> deps = new HashSet<Dependency>();
            for (ComponentDependencyRegistry.DependencyType type : ComponentDependencyRegistry.DependencyType.values()) {
                Set<String> dependencies = this.componentDependencyRegistry.getDependencies(className, type);
                for (String dependency : dependencies) {
                    deps.add(new Dependency(dependency, type));
                }
            }
            nodeMap.put(className, new Node(this.getNodeLabel(className), className, deps));
        }
    }

    private static final class Node {
        private final String id;
        private final String className;
        private final String label;
        private final Set<Dependency> dependencies = new HashSet<Dependency>();

        public Node(String logicalName, String className, Collection<Dependency> dependencies) {
            this.label = ComponentDependencyGraphvizGeneratorImpl.getNodeLabel(className, logicalName, true);
            this.id = ComponentDependencyGraphvizGeneratorImpl.escapeNodeId(ComponentDependencyGraphvizGeneratorImpl.getNodeLabel(className, logicalName, false));
            this.className = className;
            this.dependencies.addAll(dependencies);
        }
    }

    private static final class Dependency {
        private final String className;
        private final ComponentDependencyRegistry.DependencyType type;

        public Dependency(String className, ComponentDependencyRegistry.DependencyType type) {
            this.className = className;
            this.type = type;
        }

        public String toString() {
            return "Dependency [className=" + this.className + ", type=" + (Object)((Object)this.type) + "]";
        }
    }
}

